/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.kite.core.dynamic.Condition;
import com.github.developframework.kite.core.element.IfKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.json.ContentJsonProcessor;
import com.github.developframework.kite.core.processor.json.FunctionalJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import java.util.Iterator;
import java.util.Optional;

public class IfJsonProcessor
extends FunctionalJsonProcessor<IfKiteElement, ObjectNode> {
    public IfJsonProcessor(JsonProcessContext jsonProcessContext, IfKiteElement element, ObjectNode node, Expression parentExpression) {
        super(jsonProcessContext, element, node, parentExpression);
    }

    @Override
    protected void handleCoreLogic(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        boolean verifyResult;
        String conditionValue = ((IfKiteElement)this.element).getConditionValue();
        Optional<Object> conditionOptional = this.jsonProcessContext.getDataModel().getData(conditionValue);
        Object condition = conditionOptional.orElseGet(() -> {
            try {
                return Class.forName(conditionValue).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new KiteException("The condition's Class \"%s\" not found, and it's also not a expression.", conditionValue);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new KiteException("Can't new condition instance.");
            }
        });
        if (condition instanceof Boolean) {
            verifyResult = (Boolean)condition;
        } else if (condition instanceof Condition) {
            verifyResult = ((Condition)condition).verify(this.jsonProcessContext.getDataModel(), parentProcessor.getExpression());
        } else {
            throw new KiteException("The expression \"%s\" is not Condition instance.", ((IfKiteElement)this.element).getConditionValue());
        }
        if (verifyResult) {
            this.executeIfTrue(parentProcessor);
        } else {
            this.executeIfFalse(parentProcessor);
        }
    }

    private void executeIfTrue(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Iterator<KiteElement> iterator = ((IfKiteElement)this.element).childElementIterator();
        while (iterator.hasNext()) {
            KiteElement childElement = iterator.next();
            JsonProcessor<? extends KiteElement, ? extends JsonNode> nextProcessor = childElement.createJsonProcessor(this.jsonProcessContext, (ObjectNode)this.node, this.expression);
            nextProcessor.process(parentProcessor);
        }
    }

    private void executeIfFalse(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        ((IfKiteElement)this.element).getElseElement().ifPresent(elseElement -> {
            JsonProcessor<? extends KiteElement, ? extends JsonNode> elseProcessor = elseElement.createJsonProcessor(this.jsonProcessContext, (ObjectNode)parentProcessor.getNode(), parentProcessor.getExpression());
            elseProcessor.process(parentProcessor);
        });
    }
}

