/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.xml;

import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ObjectExpression;
import com.github.developframework.kite.core.data.DataModel;
import com.github.developframework.kite.core.dynamic.MapFunction;
import com.github.developframework.kite.core.element.ArrayKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.exception.InvalidArgumentsException;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.xml.ContainerXmlProcessor;
import com.github.developframework.kite.core.processor.xml.ContentXmlProcessor;
import com.github.developframework.kite.core.processor.xml.ObjectInArrayXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import java.util.List;
import java.util.Optional;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayXmlProcessor
extends ContainerXmlProcessor<ArrayKiteElement, Node> {
    private static final Logger log = LoggerFactory.getLogger(ArrayXmlProcessor.class);
    private Optional<MapFunction> mapFunctionOptional;

    public ArrayXmlProcessor(XmlProcessContext xmlProcessContext, ArrayKiteElement element, Expression parentExpression) {
        super(xmlProcessContext, element, parentExpression);
        this.mapFunctionOptional = this.mapFunction(element.getMapFunctionValueOptional(), xmlProcessContext.getDataModel());
        if (this.mapFunctionOptional.isPresent() && !element.isChildElementEmpty()) {
            log.warn("The child element invalid, because you use \"map-function\" attribute.");
        }
    }

    @Override
    protected boolean prepare(ContentXmlProcessor<? extends KiteElement, ? extends Node> parentProcessor) {
        Optional<Object> valueOptional = this.xmlProcessContext.getDataModel().getData(this.expression);
        if (valueOptional.isPresent()) {
            this.value = valueOptional.get();
            this.node = ((Element)parentProcessor.getNode()).addElement(((ArrayKiteElement)this.element).showNameXML());
            return true;
        }
        if (!((ArrayKiteElement)this.element).isNullHidden()) {
            ((Element)parentProcessor.getNode()).addElement(((ArrayKiteElement)this.element).showNameXML());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentXmlProcessor<? extends KiteElement, ? extends Node> parentProcessor) {
        int size;
        if (this.value.getClass().isArray()) {
            size = ((Object[])this.value).length;
        } else if (this.value instanceof List) {
            size = ((List)this.value).size();
        } else {
            throw new InvalidArgumentsException("data", this.expression.toString(), "Data must be array or List type.");
        }
        for (int i = 0; i < size; ++i) {
            this.single(ArrayExpression.fromObject((ObjectExpression)((ObjectExpression)this.expression), (int)i), size);
        }
    }

    protected final void single(ArrayExpression arrayExpression, int size) {
        if (((ArrayKiteElement)this.element).isChildElementEmpty() || this.mapFunctionOptional.isPresent()) {
            this.empty(arrayExpression.getIndex());
        } else {
            ObjectInArrayXmlProcessor childProcessor = new ObjectInArrayXmlProcessor(this.xmlProcessContext, ((ArrayKiteElement)this.element).getItemObjectElement(), (Expression)arrayExpression, size);
            childProcessor.process(this);
        }
    }

    private void empty(int index) {
        Optional<Object> objectOptional = this.xmlProcessContext.getDataModel().getData((Expression)ArrayExpression.fromObject((ObjectExpression)((ObjectExpression)this.expression), (int)index));
        if (!objectOptional.isPresent()) {
            return;
        }
        Object object = objectOptional.get();
        if (this.mapFunctionOptional.isPresent()) {
            object = this.mapFunctionOptional.get().apply(object, index);
        }
        ((Element)this.node).addElement(((ArrayKiteElement)this.element).getXmlItemName()).addText(object.toString());
    }

    private Optional<MapFunction> mapFunction(Optional<String> mapFunctionValueOptional, DataModel dataModel) {
        if (mapFunctionValueOptional.isPresent()) {
            String mapFunctionValue = mapFunctionValueOptional.get();
            Optional<Object> mapFunctionOptional = dataModel.getData(mapFunctionValue);
            Object obj = mapFunctionOptional.orElseGet(() -> {
                try {
                    return Class.forName(mapFunctionValue).newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidArgumentsException("map-function", mapFunctionValue, "Class not found, and it's also not a expression.");
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new KiteException("Can't new mapFunction instance.");
                }
            });
            if (obj instanceof MapFunction) {
                return Optional.of((MapFunction)obj);
            }
            throw new InvalidArgumentsException("map-function", mapFunctionValue, "It's not a MapFunction instance.");
        }
        return Optional.empty();
    }
}

