/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.saxparser;

import com.github.developframework.kite.core.ConfigurationSource;
import com.github.developframework.kite.core.FileConfigurationSource;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.exception.KiteParseXmlException;
import com.github.developframework.kite.core.saxparser.ConfigurationSaxParseHandler;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public class KiteConfigurationSaxReader {
    private static final Logger log = LoggerFactory.getLogger(KiteConfigurationSaxReader.class);
    private Set<ConfigurationSource> sources;

    public KiteConfigurationSaxReader(String config) {
        this.sources = new HashSet<ConfigurationSource>(1);
        this.sources.add(new FileConfigurationSource(config));
    }

    public KiteConfigurationSaxReader(ConfigurationSource source) {
        this.sources = new HashSet<ConfigurationSource>(1);
        this.sources.add(source);
    }

    public KiteConfigurationSaxReader(Set<ConfigurationSource> sources) {
        this.sources = sources;
    }

    public KiteConfiguration readConfiguration() {
        KiteConfiguration kiteConfiguration = new KiteConfiguration();
        ConfigurationSaxParseHandler handler = new ConfigurationSaxParseHandler(kiteConfiguration);
        for (ConfigurationSource source : this.sources) {
            this.handleSingleSource(handler, source);
            log.info("Kite framework loaded the configuration source \"{}\".", (Object)source.getSourceName());
        }
        return kiteConfiguration;
    }

    private void handleSingleSource(ConfigurationSaxParseHandler handler, ConfigurationSource source) {
        try {
            InputStream is = source.getInputStream();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)handler);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KiteParseXmlException("Kite Framework parse configuration source \"%s\" happened error: %s", source.getSourceName(), e.getMessage());
        }
    }

    public Set<ConfigurationSource> getSources() {
        return this.sources;
    }
}

