/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.kite.core.JsonProducer;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.data.DataModel;
import com.github.developframework.kite.core.element.ArrayKiteElement;
import com.github.developframework.kite.core.element.Template;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.json.ArrayTemplateJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.TemplateJsonProcessor;
import java.util.List;
import java.util.Set;

class DefaultJsonProducer
implements JsonProducer {
    private KiteConfiguration kiteConfiguration;

    DefaultJsonProducer(KiteConfiguration kiteConfiguration) {
        this.kiteConfiguration = kiteConfiguration;
    }

    @Override
    public String produce(DataModel dataModel, String namespace, String templateId) {
        return this.produce(dataModel, namespace, templateId, false);
    }

    @Override
    public String produce(DataModel dataModel, String namespace, String templateId, boolean isPretty) {
        JsonNode root = this.constructRootTree(dataModel, namespace, templateId);
        if (root == null) {
            return null;
        }
        try {
            if (isPretty) {
                return this.kiteConfiguration.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)root);
            }
            return this.kiteConfiguration.getObjectMapper().writeValueAsString((Object)root);
        }
        catch (JsonProcessingException e) {
            throw new KiteException("produce json string failed.");
        }
    }

    @Override
    public void outputJson(JsonGenerator jsonGenerator, DataModel dataModel, String namespace, String templateId, boolean isPretty) {
        JsonNode root = this.constructRootTree(dataModel, namespace, templateId);
        if (root != null) {
            try {
                if (isPretty) {
                    this.kiteConfiguration.getObjectMapper().writerWithDefaultPrettyPrinter().writeValue(jsonGenerator, (Object)root);
                } else {
                    this.kiteConfiguration.getObjectMapper().writer().writeValue(jsonGenerator, (Object)root);
                }
            }
            catch (Exception e) {
                throw new KiteException("produce json string failed.");
            }
        }
    }

    private JsonNode constructRootTree(DataModel dataModel, String namespace, String id) {
        Template template = this.kiteConfiguration.extractTemplate(namespace, id);
        JsonProcessContext jsonProcessContext = new JsonProcessContext();
        jsonProcessContext.setDataModel(dataModel);
        jsonProcessContext.setConfiguration(this.kiteConfiguration);
        DataDefinition templateDataDefinition = template.getDataDefinition();
        if (templateDataDefinition != null) {
            return dataModel.getData(templateDataDefinition.getExpression()).map(rootObject -> {
                if (rootObject.getClass().isArray() || rootObject instanceof List || rootObject instanceof Set) {
                    return this.constructRootArrayNodeTree(jsonProcessContext, template, rootObject);
                }
                return this.constructRootObjectNodeTree(jsonProcessContext, template, rootObject);
            }).orElse(null);
        }
        return this.constructRootObjectNodeTree(jsonProcessContext, template, null);
    }

    private ObjectNode constructRootObjectNodeTree(JsonProcessContext jsonProcessContext, Template template, Object value) {
        ObjectNode rootNode = this.kiteConfiguration.getObjectMapper().createObjectNode();
        TemplateJsonProcessor templateProcessor = new TemplateJsonProcessor(jsonProcessContext, template);
        templateProcessor.setValue(value);
        templateProcessor.setNode(rootNode);
        templateProcessor.process(null);
        return rootNode;
    }

    private ArrayNode constructRootArrayNodeTree(JsonProcessContext jsonProcessContext, Template template, Object value) {
        ArrayNode rootNode = this.kiteConfiguration.getObjectMapper().createArrayNode();
        ArrayKiteElement arrayElement = new ArrayKiteElement(this.kiteConfiguration, template.getTemplateLocation(), template.getDataDefinition(), null);
        arrayElement.setMapFunctionValue(template.getMapFunctionValue());
        ArrayTemplateJsonProcessor arrayProcessor = new ArrayTemplateJsonProcessor(jsonProcessContext, template, arrayElement);
        arrayProcessor.setValue(value);
        arrayProcessor.setNode(rootNode);
        arrayProcessor.process(null);
        return rootNode;
    }
}

