/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.developframework.kite.core.TemplateLocation;
import com.github.developframework.kite.core.element.Template;
import com.github.developframework.kite.core.element.TemplatePackage;
import com.github.developframework.kite.core.exception.ResourceNotUniqueException;
import com.github.developframework.kite.core.exception.TemplatePackageUndefinedException;
import com.github.developframework.kite.core.strategy.DefaultXmlKitePropertyNamingStrategy;
import com.github.developframework.kite.core.strategy.JacksonKitePropertyNamingStrategy;
import com.github.developframework.kite.core.strategy.KitePropertyNamingStrategy;
import java.util.HashMap;
import java.util.Map;

public class KiteConfiguration {
    private ObjectMapper objectMapper;
    private Map<String, TemplatePackage> templatePackages;
    private KitePropertyNamingStrategy forJsonStrategy = new JacksonKitePropertyNamingStrategy();
    private KitePropertyNamingStrategy forXmlStrategy = new DefaultXmlKitePropertyNamingStrategy();
    private boolean xmlSuppressDeclaration = true;

    public KiteConfiguration() {
        this.templatePackages = new HashMap<String, TemplatePackage>();
    }

    public void putTemplatePackage(TemplatePackage templatePackage) {
        String namespace = templatePackage.getNamespace();
        if (this.templatePackages.containsKey(namespace)) {
            throw new ResourceNotUniqueException("Kite package", namespace);
        }
        this.templatePackages.put(namespace, templatePackage);
    }

    public TemplatePackage getTemplatePackageByNamespace(String namespace) {
        TemplatePackage templatePackage = this.templatePackages.get(namespace);
        if (templatePackage == null) {
            throw new TemplatePackageUndefinedException(namespace);
        }
        return templatePackage;
    }

    public Template extractTemplate(String namespace, String templateId) {
        return this.getTemplatePackageByNamespace(namespace).getTemplateById(templateId);
    }

    public Template extractTemplate(TemplateLocation templateLocation) {
        return this.getTemplatePackageByNamespace(templateLocation.getNamespace()).getTemplateById(templateLocation.getTemplateId());
    }

    public void setForJsonStrategy(KitePropertyNamingStrategy forJsonStrategy) {
        if (forJsonStrategy != null) {
            this.forJsonStrategy = forJsonStrategy;
        }
    }

    public void setForXmlStrategy(KitePropertyNamingStrategy forXmlStrategy) {
        if (forXmlStrategy != null) {
            this.forXmlStrategy = forXmlStrategy;
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public KitePropertyNamingStrategy getForJsonStrategy() {
        return this.forJsonStrategy;
    }

    public KitePropertyNamingStrategy getForXmlStrategy() {
        return this.forXmlStrategy;
    }

    public boolean isXmlSuppressDeclaration() {
        return this.xmlSuppressDeclaration;
    }

    public void setXmlSuppressDeclaration(boolean xmlSuppressDeclaration) {
        this.xmlSuppressDeclaration = xmlSuppressDeclaration;
    }
}

