/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.data;

import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ExpressionUtils;
import com.github.developframework.kite.core.dynamic.CaseTestFunction;
import com.github.developframework.kite.core.dynamic.KiteCondition;
import com.github.developframework.kite.core.dynamic.KiteConverter;
import com.github.developframework.kite.core.dynamic.MapFunction;
import com.github.developframework.kite.core.dynamic.RelFunction;
import com.github.developframework.kite.core.exception.DataUndefinedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class DataModel {
    private Map<String, Object> dataMap = new HashMap<String, Object>();

    public DataModel() {
    }

    public DataModel(Map<String, Object> dataMap) {
        this.dataMap.putAll(dataMap);
    }

    public boolean contains(String dataName) {
        return this.dataMap.containsKey(dataName);
    }

    public DataModel putData(String dataName, Object data) {
        this.dataMap.put(dataName, data);
        return this;
    }

    public DataModel putConverter(String dataName, KiteConverter<?, ?> converter) {
        return this.putData(dataName, converter);
    }

    public DataModel putCondition(String dataName, KiteCondition<?> condition) {
        return this.putData(dataName, condition);
    }

    public DataModel putCaseTestFunction(String dataName, CaseTestFunction<?> function) {
        return this.putData(dataName, function);
    }

    public DataModel putRelFunction(String dataName, RelFunction<?, ?> function) {
        return this.putData(dataName, function);
    }

    public DataModel putMapFunction(String dataName, MapFunction<?, ?> function) {
        return this.putData(dataName, function);
    }

    public Optional<Object> getData(Expression expression) {
        return Optional.ofNullable(ExpressionUtils.getValue(this.dataMap, (Expression)expression));
    }

    public Optional<Object> getData(String expressionValue) {
        return this.getData(Expression.parse((String)expressionValue));
    }

    public Optional<Object> getData(Object object, Expression expression) {
        return Optional.ofNullable(ExpressionUtils.getValue((Object)object, (Expression)expression));
    }

    public Optional<Object> getData(Object object, String expressionValue) {
        return this.getData(object, Expression.parse((String)expressionValue));
    }

    public Object getDataRequired(Expression expression) {
        Object value = ExpressionUtils.getValue(this.dataMap, (Expression)expression);
        if (value == null) {
            throw new DataUndefinedException(expression.toString());
        }
        return value;
    }

    public Object getDataRequired(Object object, Expression expression) {
        Object value = ExpressionUtils.getValue((Object)object, (Expression)expression);
        if (value == null) {
            throw new DataUndefinedException(expression.toString());
        }
        return value;
    }

    public Object getDataRequired(String expressionValue) {
        return this.getDataRequired(Expression.parse((String)expressionValue));
    }

    public Object getDataRequired(Object object, String expressionValue) {
        Object value = ExpressionUtils.getValue((Object)object, (String)expressionValue);
        if (value == null) {
            throw new DataUndefinedException(expressionValue);
        }
        return value;
    }

    public static DataModel singleton(String dataName, Object data) {
        return new DataModel().putData(dataName, data);
    }

    public static DataModel builder() {
        return new DataModel();
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }
}

