/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.TemplateLocation;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.element.ContainChildElementable;
import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.NormalPropertyKiteElement;
import com.github.developframework.kite.core.exception.KiteParseXmlException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class ContainerKiteElement
extends ContentKiteElement
implements ContainChildElementable {
    protected List<KiteElement> childKiteElements = new ArrayList<KiteElement>();
    protected Class<?> forClass;
    protected List<String> ignorePropertyNames = new ArrayList<String>();

    public ContainerKiteElement(KiteConfiguration configuration, TemplateLocation templateLocation, DataDefinition dataDefinition, String alias) {
        super(configuration, templateLocation, dataDefinition, alias);
    }

    public void setForClass(String className) {
        if (StringUtils.isNotEmpty((CharSequence)className)) {
            try {
                this.forClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new KiteParseXmlException("Class \"%s\" is not found, please check configuration file.", className);
            }
        }
    }

    public final void addIgnoreProperty(String propertyName) {
        this.ignorePropertyNames.add(propertyName);
    }

    public final void loadForClassAllProperty() {
        if (this.forClass != null) {
            Field[] fields;
            for (Field field : fields = this.forClass.getDeclaredFields()) {
                DataDefinition dataDefinition;
                NormalPropertyKiteElement propertyElement;
                if (this.ignorePropertyNames.contains(field.getName()) || this.childKiteElements.contains(propertyElement = new NormalPropertyKiteElement(this.configuration, this.templateLocation, dataDefinition = new DataDefinition(field.getName()), null))) continue;
                this.addChildElement(propertyElement);
            }
        }
    }

    public void copyChildElement(ContainerKiteElement otherContainerElement) {
        this.childKiteElements.addAll(otherContainerElement.getChildKiteElements());
        this.ignorePropertyNames.addAll(otherContainerElement.ignorePropertyNames);
        this.alias = otherContainerElement.alias;
        this.forClass = otherContainerElement.forClass;
        this.nullHidden = otherContainerElement.nullHidden;
        this.templateLocation = otherContainerElement.templateLocation;
    }

    @Override
    public void addChildElement(KiteElement kiteElement) {
        this.childKiteElements.add(kiteElement);
    }

    @Override
    public final void copyChildElement(ContainChildElementable otherContainer) {
        this.childKiteElements.addAll(otherContainer.getChildKiteElements());
    }

    @Override
    public final Iterator<KiteElement> childElementIterator() {
        return this.childKiteElements.iterator();
    }

    @Override
    public final boolean isChildElementEmpty() {
        return this.childKiteElements.isEmpty();
    }

    @Override
    public final List<KiteElement> getChildKiteElements() {
        return this.childKiteElements;
    }

    public Class<?> getForClass() {
        return this.forClass;
    }
}

