/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.TemplateLocation;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.PropertyKiteElement;
import com.github.developframework.kite.core.processor.json.EnumPropertyJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import com.github.developframework.kite.core.processor.xml.EnumPropertyXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.processor.xml.XmlProcessor;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;

public class EnumPropertyKiteElement
extends PropertyKiteElement {
    private Map<String, String> enumMap;

    public EnumPropertyKiteElement(KiteConfiguration configuration, TemplateLocation templateLocation, DataDefinition dataDefinition, String alias) {
        super(configuration, templateLocation, dataDefinition, alias);
    }

    @Override
    public JsonProcessor<? extends KiteElement, ? extends JsonNode> createJsonProcessor(JsonProcessContext context, ObjectNode parentNode) {
        EnumPropertyJsonProcessor processor = new EnumPropertyJsonProcessor(context, this);
        processor.setNode(parentNode);
        return processor;
    }

    @Override
    public XmlProcessor<? extends KiteElement, ? extends Element> createXmlProcessor(XmlProcessContext context, Element parentNode) {
        EnumPropertyXmlProcessor processor = new EnumPropertyXmlProcessor(context, this);
        processor.setNode(parentNode);
        return processor;
    }

    public void putEnumText(String enumValue, String text) {
        if (this.enumMap == null) {
            this.enumMap = new HashMap<String, String>();
        }
        this.enumMap.putIfAbsent(enumValue, text);
    }

    public String getEnumText(String enumValue) {
        if (this.enumMap == null) {
            return null;
        }
        return this.enumMap.get(enumValue);
    }

    public Map<String, String> getEnumMap() {
        return this.enumMap;
    }
}

