/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.TemplateLocation;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.element.ArrayKiteElement;
import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.ObjectKiteElement;
import com.github.developframework.kite.core.element.ProxyNormalPropertyKiteElement;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import com.github.developframework.kite.core.processor.json.RelevanceJsonProcessor;
import com.github.developframework.kite.core.processor.xml.RelevanceXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.processor.xml.XmlProcessor;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class RelevanceKiteElement
extends ArrayKiteElement {
    private String relFunctionValue;
    private RelevanceType relevanceType;
    protected String innerConverterValue;

    public RelevanceKiteElement(KiteConfiguration configuration, TemplateLocation templateLocation, DataDefinition dataDefinition, String alias) {
        super(configuration, templateLocation, dataDefinition, alias);
    }

    @Override
    public JsonProcessor<? extends KiteElement, ? extends JsonNode> createJsonProcessor(JsonProcessContext context, ObjectNode parentNode) {
        return new RelevanceJsonProcessor(context, this);
    }

    @Override
    public XmlProcessor<? extends KiteElement, ? extends Element> createXmlProcessor(XmlProcessContext context, Element parentNode) {
        return new RelevanceXmlProcessor(context, this);
    }

    public void setRelevanceType(String relevanceTypeValue) {
        this.relevanceType = StringUtils.isNotEmpty((CharSequence)relevanceTypeValue) ? RelevanceType.valueOf(relevanceTypeValue.toUpperCase()) : RelevanceType.MULTIPLE;
    }

    public ContentKiteElement createProxyObjectElement() {
        if (this.isChildElementEmpty()) {
            return new ProxyNormalPropertyKiteElement(this.configuration, this.templateLocation, this.dataDefinition, this.alias);
        }
        return new ObjectKiteElement(this.configuration, this, this.dataDefinition);
    }

    public ContentKiteElement createProxyArrayElement() {
        ArrayKiteElement arrayKiteElement = new ArrayKiteElement(this.configuration, this, this.dataDefinition);
        arrayKiteElement.setXmlItemName(this.xmlItemName);
        arrayKiteElement.setMapFunctionValue(this.mapFunctionValue);
        arrayKiteElement.setComparatorValue(this.comparatorValue);
        arrayKiteElement.setConverterValue(this.converterValue);
        return arrayKiteElement;
    }

    public Optional<String> getRelFunctionValue() {
        return Optional.ofNullable(this.relFunctionValue);
    }

    public Optional<String> getInnerConverterValue() {
        return Optional.ofNullable(this.innerConverterValue);
    }

    public void setRelFunctionValue(String relFunctionValue) {
        this.relFunctionValue = relFunctionValue;
    }

    public RelevanceType getRelevanceType() {
        return this.relevanceType;
    }

    public void setInnerConverterValue(String innerConverterValue) {
        this.innerConverterValue = innerConverterValue;
    }

    public static enum RelevanceType {
        AUTO,
        SINGLE,
        MULTIPLE;

    }
}

