/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.TemplateLocation;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.element.DuplicateTemplateKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.ObjectKiteElement;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import com.github.developframework.kite.core.processor.json.TemplateJsonProcessor;
import com.github.developframework.kite.core.processor.xml.TemplateXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.processor.xml.XmlProcessor;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class Template
extends ObjectKiteElement {
    private Extend extend;
    private String mapFunctionValue;
    private String xmlRootName;
    private String xmlItemName;

    public Template(KiteConfiguration configuration, TemplateLocation templateLocation) {
        super(configuration, templateLocation, null, null);
    }

    @Override
    public JsonProcessor<? extends KiteElement, ? extends JsonNode> createJsonProcessor(JsonProcessContext jsonProcessContext, ObjectNode parentNode) {
        TemplateJsonProcessor templateProcessor = new TemplateJsonProcessor(jsonProcessContext, this);
        templateProcessor.setNode(parentNode);
        return templateProcessor;
    }

    @Override
    public XmlProcessor<? extends KiteElement, ? extends Element> createXmlProcessor(XmlProcessContext xmlProcessContext, Element parentNode) {
        TemplateXmlProcessor templateProcessor = new TemplateXmlProcessor(xmlProcessContext, this);
        templateProcessor.setNode(parentNode);
        return templateProcessor;
    }

    public Optional<Extend> getExtend() {
        return Optional.ofNullable(this.extend);
    }

    public DuplicateTemplateKiteElement createDuplicateTemplateKiteElement() {
        return new DuplicateTemplateKiteElement(this.configuration, this);
    }

    public String getXmlRootName() {
        if (StringUtils.isEmpty((CharSequence)this.xmlRootName) && this.dataDefinition == DataDefinition.EMPTY_DATA_DEFINITION) {
            throw new KiteException("\"xml-root\" is undefined in template \"%s\".", this.templateLocation);
        }
        return this.xmlRootName;
    }

    public String getXmlItemName() {
        if (StringUtils.isEmpty((CharSequence)this.xmlItemName)) {
            throw new KiteException("\"xml-item\" is undefined in template \"%s\".", this.templateLocation);
        }
        return this.xmlItemName;
    }

    public void setExtend(Extend extend) {
        this.extend = extend;
    }

    public void setMapFunctionValue(String mapFunctionValue) {
        this.mapFunctionValue = mapFunctionValue;
    }

    public String getMapFunctionValue() {
        return this.mapFunctionValue;
    }

    public void setXmlRootName(String xmlRootName) {
        this.xmlRootName = xmlRootName;
    }

    public void setXmlItemName(String xmlItemName) {
        this.xmlItemName = xmlItemName;
    }

    public class Extend {
        private TemplateLocation extendTemplateLocation;
        private String port;

        public Extend(String extendValue, String defaultNamespace) {
            String templateId;
            String namespace;
            String front = StringUtils.substringBefore((String)extendValue, (String)":");
            this.port = StringUtils.substringAfter((String)extendValue, (String)":");
            if (front.contains(".")) {
                namespace = StringUtils.substringBefore((String)front, (String)".");
                templateId = StringUtils.substringAfter((String)front, (String)".");
            } else {
                namespace = defaultNamespace;
                templateId = front;
            }
            this.extendTemplateLocation = new TemplateLocation(namespace, templateId);
        }

        public TemplateLocation getExtendTemplateLocation() {
            return this.extendTemplateLocation;
        }

        public String getPort() {
            return this.port;
        }
    }
}

