/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.ExpressionUtils;
import com.github.developframework.kite.core.dynamic.MapFunction;
import com.github.developframework.kite.core.element.ArrayKiteElement;
import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.processor.json.ContainerJsonProcessor;
import com.github.developframework.kite.core.processor.json.ContentJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.ObjectInArrayJsonProcessor;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayJsonProcessor
extends ContainerJsonProcessor<ArrayKiteElement, ArrayNode> {
    private static final Logger log = LoggerFactory.getLogger(ArrayJsonProcessor.class);

    public ArrayJsonProcessor(JsonProcessContext jsonProcessContext, ArrayKiteElement element) {
        super(jsonProcessContext, element);
    }

    @Override
    protected boolean prepare(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Optional<Object> valueOptional = this.getDataValue(parentProcessor);
        if (valueOptional.isPresent()) {
            this.value = KiteUtils.objectToArray(valueOptional.get(), (ContentKiteElement)this.element);
            this.node = ((ObjectNode)parentProcessor.node).putArray(((ArrayKiteElement)this.element).showNameJSON());
            return true;
        }
        if (!((ArrayKiteElement)this.element).isNullHidden()) {
            if (((ArrayKiteElement)this.element).isNullEmpty()) {
                ((ObjectNode)parentProcessor.node).putArray(((ArrayKiteElement)this.element).showNameJSON());
            } else {
                ((ObjectNode)parentProcessor.node).putNull(((ArrayKiteElement)this.element).showNameJSON());
            }
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Object[] array = (Object[])this.value;
        ((ArrayKiteElement)this.element).getComparatorValue().map(comparatorValue -> KiteUtils.getComponentInstance(this.jsonProcessContext.getDataModel(), comparatorValue, Comparator.class, "comparator")).ifPresent(comparator -> Arrays.sort(array, comparator));
        int length = ((ArrayKiteElement)this.element).getLimit() != null && ((ArrayKiteElement)this.element).getLimit() < array.length ? ((ArrayKiteElement)this.element).getLimit() : array.length;
        for (int i = 0; i < length; ++i) {
            if (((ArrayKiteElement)this.element).getMapFunctionValue().isPresent()) {
                Object itemValue;
                String mapFunctionValue;
                if (!((ArrayKiteElement)this.element).isChildElementEmpty()) {
                    log.warn("The child element invalid, because you use \"map\" attribute.");
                }
                if ((mapFunctionValue = ((ArrayKiteElement)this.element).getMapFunctionValue().get()).startsWith("this.")) {
                    itemValue = ExpressionUtils.getValue((Object)array[i], (String)mapFunctionValue.substring(5));
                } else {
                    MapFunction mapFunction = ((ArrayKiteElement)this.element).getMapFunctionValue().map(mfv -> KiteUtils.getComponentInstance(this.jsonProcessContext.getDataModel(), mfv, MapFunction.class, "map")).get();
                    itemValue = mapFunction.apply(array[i], i);
                }
                this.empty(itemValue);
                continue;
            }
            if (((ArrayKiteElement)this.element).isChildElementEmpty()) {
                this.empty(array[i]);
                continue;
            }
            ObjectInArrayJsonProcessor childProcessor = new ObjectInArrayJsonProcessor(this.jsonProcessContext, ((ArrayKiteElement)this.element).getItemObjectElement(), i, length);
            childProcessor.setValue(array[i]);
            childProcessor.process(this);
            ((ArrayNode)this.node).add(childProcessor.node);
        }
    }

    private void empty(Object itemValue) {
        if (itemValue == null) {
            ((ArrayNode)this.node).addNull();
            return;
        }
        if (itemValue instanceof String) {
            ((ArrayNode)this.node).add((String)itemValue);
        } else if (itemValue instanceof Integer) {
            ((ArrayNode)this.node).add((Integer)itemValue);
        } else if (itemValue instanceof Long) {
            ((ArrayNode)this.node).add((Long)itemValue);
        } else if (itemValue instanceof Short) {
            ((ArrayNode)this.node).add((int)((Short)itemValue).shortValue());
        } else if (itemValue instanceof Boolean) {
            ((ArrayNode)this.node).add((Boolean)itemValue);
        } else if (itemValue instanceof Float) {
            ((ArrayNode)this.node).add((Float)itemValue);
        } else if (itemValue instanceof Double) {
            ((ArrayNode)this.node).add((Double)itemValue);
        } else if (itemValue instanceof BigDecimal) {
            ((ArrayNode)this.node).add((BigDecimal)itemValue);
        } else if (itemValue instanceof Character) {
            ((ArrayNode)this.node).add((int)((Character)itemValue).charValue());
        } else if (itemValue instanceof Byte) {
            ((ArrayNode)this.node).add((int)((Byte)itemValue).byteValue());
        } else {
            ((ArrayNode)this.node).add(itemValue.toString());
        }
    }
}

