/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.kite.core.element.PropertyKiteElement;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.PropertyJsonProcessor;
import java.util.HashSet;
import java.util.Set;

public class BooleanPropertyJsonProcessor
extends PropertyJsonProcessor {
    private static final Set<Class<?>> ACCEPT_CLASS_SET = new HashSet();

    public BooleanPropertyJsonProcessor(JsonProcessContext jsonProcessContext, PropertyKiteElement element) {
        super(jsonProcessContext, element);
    }

    @Override
    protected boolean support(Class<?> sourceClass) {
        return ACCEPT_CLASS_SET.contains(sourceClass);
    }

    @Override
    protected void handle(ObjectNode parentNode, Class<?> clazz, Object value, String showName) {
        boolean v;
        if (clazz == Boolean.class) {
            v = (Boolean)value;
        } else if (clazz == Integer.class) {
            v = (Integer)value != 0;
        } else if (clazz == Long.class) {
            v = (Long)value != 0L;
        } else if (clazz == Short.class) {
            v = (Short)value != 0;
        } else {
            parentNode.putNull(showName);
            return;
        }
        parentNode.put(showName, v);
    }

    static {
        ACCEPT_CLASS_SET.add(Boolean.TYPE);
        ACCEPT_CLASS_SET.add(Boolean.class);
        ACCEPT_CLASS_SET.add(Integer.TYPE);
        ACCEPT_CLASS_SET.add(Integer.class);
        ACCEPT_CLASS_SET.add(Long.TYPE);
        ACCEPT_CLASS_SET.add(Long.class);
        ACCEPT_CLASS_SET.add(Short.TYPE);
        ACCEPT_CLASS_SET.add(Short.class);
    }
}

