/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.developframework.expression.ExpressionUtils;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.data.FunctionSign;
import com.github.developframework.kite.core.dynamic.KiteConverter;
import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.util.Objects;
import java.util.Optional;

public abstract class ContentJsonProcessor<ELEMENT extends ContentKiteElement, NODE extends JsonNode>
extends JsonProcessor<ELEMENT, NODE> {
    public ContentJsonProcessor(JsonProcessContext jsonProcessContext, ELEMENT element) {
        super(jsonProcessContext, element, null);
    }

    protected Optional<Object> getDataValue(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        if (Objects.nonNull(this.value)) {
            return Optional.of(this.value);
        }
        DataDefinition dataDefinition = ((ContentKiteElement)this.element).getDataDefinition();
        Optional<Object> nextValueOptional = dataDefinition.getFunctionSign() == FunctionSign.ROOT || Objects.isNull(parentProcessor.value) ? this.jsonProcessContext.getDataModel().getData(dataDefinition.getExpression()) : this.jsonProcessContext.getDataModel().getData(parentProcessor.value, dataDefinition.getExpression());
        Object nextValue = nextValueOptional.orElse(null);
        if (((ContentKiteElement)this.element).getConverterValue().isPresent()) {
            String converterValue = ((ContentKiteElement)this.element).getConverterValue().get();
            if (converterValue.startsWith("this.")) {
                return Optional.ofNullable(ExpressionUtils.getValue((Object)parentProcessor.value, (String)converterValue.substring(5)));
            }
            KiteConverter converter = KiteUtils.getComponentInstance(this.jsonProcessContext.getDataModel(), converterValue, KiteConverter.class, "converter");
            return Optional.ofNullable(converter.convert(nextValue));
        }
        return nextValueOptional;
    }
}

