/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.kite.core.element.EnumPropertyKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.json.ContentJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import java.util.Optional;

public class EnumPropertyJsonProcessor
extends ContentJsonProcessor<EnumPropertyKiteElement, ObjectNode> {
    public EnumPropertyJsonProcessor(JsonProcessContext jsonProcessContext, EnumPropertyKiteElement element) {
        super(jsonProcessContext, element);
    }

    @Override
    protected boolean prepare(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Optional<Object> valueOptional = this.getDataValue(parentProcessor);
        if (valueOptional.isPresent()) {
            this.value = valueOptional.get();
            this.node = (ObjectNode)parentProcessor.getNode();
            return true;
        }
        if (!((EnumPropertyKiteElement)this.element).isNullHidden()) {
            ((ObjectNode)parentProcessor.getNode()).putNull(((EnumPropertyKiteElement)this.element).showNameJSON());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        String enumValue = this.value.toString();
        String enumText = ((EnumPropertyKiteElement)this.element).getEnumText(enumValue);
        if (enumText == null) {
            throw new KiteException("No enum value for \"%s\" in template \"%s\".", enumValue, ((EnumPropertyKiteElement)this.element).getTemplateLocation());
        }
        ((ObjectNode)this.node).put(((EnumPropertyKiteElement)this.element).showNameJSON(), enumText);
    }
}

