/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.kite.core.dynamic.KiteCondition;
import com.github.developframework.kite.core.element.IfKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.processor.json.ContentJsonProcessor;
import com.github.developframework.kite.core.processor.json.FunctionalJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.util.Iterator;

public class IfJsonProcessor
extends FunctionalJsonProcessor<IfKiteElement, ObjectNode> {
    public IfJsonProcessor(JsonProcessContext jsonProcessContext, IfKiteElement element, ObjectNode node) {
        super(jsonProcessContext, element, node);
    }

    @Override
    protected void handleCoreLogic(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        ((IfKiteElement)this.element).getConditionValue().ifPresent(conditionValue -> {
            Boolean flag = this.jsonProcessContext.getDataModel().getData((String)conditionValue).filter(v -> v instanceof Boolean).orElse(null);
            if (flag == null) {
                KiteCondition condition = KiteUtils.getComponentInstance(this.jsonProcessContext.getDataModel(), conditionValue, KiteCondition.class, "condition");
                flag = condition.verify(this.jsonProcessContext.getDataModel(), parentProcessor.value);
            }
            if (flag.booleanValue()) {
                this.executeIfTrue(parentProcessor);
            } else {
                this.executeIfFalse(parentProcessor);
            }
        });
    }

    private void executeIfTrue(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Iterator<KiteElement> iterator = ((IfKiteElement)this.element).childElementIterator();
        while (iterator.hasNext()) {
            KiteElement childElement = iterator.next();
            JsonProcessor<? extends KiteElement, ? extends JsonNode> nextProcessor = childElement.createJsonProcessor(this.jsonProcessContext, (ObjectNode)this.node);
            nextProcessor.process(parentProcessor);
        }
    }

    private void executeIfFalse(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        ((IfKiteElement)this.element).getElseElement().ifPresent(elseElement -> {
            JsonProcessor<? extends KiteElement, ? extends JsonNode> nextProcessor = elseElement.createJsonProcessor(this.jsonProcessContext, (ObjectNode)parentProcessor.getNode());
            nextProcessor.process(parentProcessor);
        });
    }
}

