/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.LinkKiteElement;
import com.github.developframework.kite.core.element.ObjectKiteElement;
import com.github.developframework.kite.core.exception.LinkSizeNotEqualException;
import com.github.developframework.kite.core.processor.json.ContentJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import com.github.developframework.kite.core.processor.json.ObjectInArrayJsonProcessor;
import com.github.developframework.kite.core.processor.json.ObjectJsonProcessor;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.util.Optional;

public class LinkJsonProcessor
extends ObjectJsonProcessor {
    private int index;

    public LinkJsonProcessor(JsonProcessContext jsonProcessContext, LinkKiteElement element) {
        super(jsonProcessContext, element);
    }

    @Override
    protected boolean prepare(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        this.index = ((ObjectInArrayJsonProcessor)parentProcessor).getIndex();
        Optional<Object> valueOptional = this.getDataValue(parentProcessor);
        if (valueOptional.isPresent()) {
            Object[] array = KiteUtils.objectToArray(valueOptional.get(), (ContentKiteElement)this.element);
            if (array.length != ((ObjectInArrayJsonProcessor)parentProcessor).getSize()) {
                throw new LinkSizeNotEqualException(((ObjectKiteElement)this.element).getTemplateLocation());
            }
            this.value = array[this.index];
            return true;
        }
        if (!((ObjectKiteElement)this.element).isNullHidden()) {
            ((ObjectNode)this.node).putNull(((ObjectKiteElement)this.element).showNameJSON());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        ContentKiteElement contentElement = ((LinkKiteElement)this.element).createProxyContentElement(this.value.getClass());
        JsonProcessor<? extends KiteElement, ? extends JsonNode> nextProcessor = contentElement.createJsonProcessor(this.jsonProcessContext, (ObjectNode)((ObjectInArrayJsonProcessor)parentProcessor).node);
        nextProcessor.setValue(this.value);
        nextProcessor.process(parentProcessor);
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

