/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.PropertyKiteElement;
import com.github.developframework.kite.core.processor.json.ContentJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import java.util.Optional;

public abstract class PropertyJsonProcessor
extends ContentJsonProcessor<PropertyKiteElement, ObjectNode> {
    public PropertyJsonProcessor(JsonProcessContext jsonProcessContext, PropertyKiteElement element) {
        super(jsonProcessContext, element);
    }

    @Override
    protected boolean prepare(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Optional<Object> valueOptional = this.getDataValue(parentProcessor);
        if (valueOptional.isPresent()) {
            this.value = valueOptional.get();
            this.node = (ObjectNode)parentProcessor.getNode();
            return true;
        }
        if (!((PropertyKiteElement)this.element).isNullHidden()) {
            ((ObjectNode)parentProcessor.getNode()).putNull(((PropertyKiteElement)this.element).showNameJSON());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Class<?> valueClass = this.value.getClass();
        if (this.support(valueClass)) {
            this.handle((ObjectNode)this.node, valueClass, this.value, ((PropertyKiteElement)this.element).showNameJSON());
        }
    }

    protected abstract boolean support(Class<?> var1);

    protected abstract void handle(ObjectNode var1, Class<?> var2, Object var3, String var4);
}

