/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.PrototypeKiteElement;
import com.github.developframework.kite.core.processor.json.ContentJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import java.util.Optional;

public class PrototypeJsonProcessor
extends ContentJsonProcessor<PrototypeKiteElement, ObjectNode> {
    public PrototypeJsonProcessor(JsonProcessContext jsonProcessContext, PrototypeKiteElement element) {
        super(jsonProcessContext, element);
    }

    @Override
    protected boolean prepare(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Optional<Object> valueOptional = this.getDataValue(parentProcessor);
        if (valueOptional.isPresent()) {
            this.value = valueOptional.get();
            return true;
        }
        if (!((PrototypeKiteElement)this.element).isNullHidden()) {
            ((ObjectNode)this.node).putNull(((PrototypeKiteElement)this.element).showNameJSON());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        ObjectMapper objectMapper = this.jsonProcessContext.getConfiguration().getObjectMapper();
        JsonNode jsonNode = objectMapper.valueToTree(this.value);
        ((ObjectNode)this.node).set(((PrototypeKiteElement)this.element).showNameJSON(), jsonNode);
    }
}

