/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.ExpressionUtils;
import com.github.developframework.kite.core.dynamic.KiteConverter;
import com.github.developframework.kite.core.dynamic.RelFunction;
import com.github.developframework.kite.core.element.ArrayKiteElement;
import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.RelevanceKiteElement;
import com.github.developframework.kite.core.processor.json.ArrayJsonProcessor;
import com.github.developframework.kite.core.processor.json.ContentJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import com.github.developframework.kite.core.processor.json.ObjectInArrayJsonProcessor;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelevanceJsonProcessor
extends ArrayJsonProcessor {
    private static final Logger log = LoggerFactory.getLogger(RelevanceJsonProcessor.class);
    private int index;

    public RelevanceJsonProcessor(JsonProcessContext jsonProcessContext, RelevanceKiteElement element) {
        super(jsonProcessContext, element);
    }

    @Override
    protected boolean prepare(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        this.index = ((ObjectInArrayJsonProcessor)parentProcessor).getIndex();
        Optional<Object> valueOptional = this.getDataValue(parentProcessor);
        if (valueOptional.isPresent()) {
            ObjectInArrayJsonProcessor objectInArrayProcessor = (ObjectInArrayJsonProcessor)parentProcessor;
            RelFunction relFunction = ((RelevanceKiteElement)this.element).getRelFunctionValue().map(relFunctionValue -> KiteUtils.getComponentInstance(this.jsonProcessContext.getDataModel(), relFunctionValue, RelFunction.class, "rel")).get();
            Object[] targets = KiteUtils.objectToArray(valueOptional.get(), (ContentKiteElement)this.element);
            LinkedList<Integer> indexList = new LinkedList<Integer>();
            for (int i2 = 0; i2 < targets.length; ++i2) {
                if (!relFunction.relevant(objectInArrayProcessor.value, this.index, targets[i2], i2)) continue;
                indexList.add(i2);
            }
            this.value = indexList.stream().map(i -> targets[i]).toArray();
            return true;
        }
        if (!((ArrayKiteElement)this.element).isNullHidden()) {
            if (((ArrayKiteElement)this.element).isNullEmpty()) {
                ((ObjectNode)parentProcessor.node).putArray(((ArrayKiteElement)this.element).showNameJSON());
            } else {
                ((ObjectNode)parentProcessor.node).putNull(((ArrayKiteElement)this.element).showNameJSON());
            }
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Object[] valueArray = this.forInnerConverter((Object[])this.value);
        switch (((RelevanceKiteElement)this.element).getRelevanceType()) {
            case AUTO: {
                if (valueArray.length == 1) {
                    this.generateObjectStructure(parentProcessor, valueArray);
                    break;
                }
                this.generateArrayStructure(parentProcessor, valueArray);
                break;
            }
            case SINGLE: {
                if (valueArray.length > 1) {
                    log.warn("You have more items, and you choose relevance type \"SINGLE\".");
                }
                this.generateObjectStructure(parentProcessor, valueArray);
                break;
            }
            case MULTIPLE: {
                this.generateArrayStructure(parentProcessor, valueArray);
            }
        }
    }

    private void generateObjectStructure(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor, Object[] matchItems) {
        if (matchItems.length > 0) {
            ContentKiteElement contentElement = KiteUtils.isArrayOrCollection(matchItems[0]) ? ((RelevanceKiteElement)this.element).createProxyArrayElement() : ((RelevanceKiteElement)this.element).createProxyObjectElement();
            JsonProcessor<? extends KiteElement, ? extends JsonNode> nextProcessor = contentElement.createJsonProcessor(this.jsonProcessContext, null);
            nextProcessor.value = matchItems[0];
            nextProcessor.process(parentProcessor);
        } else if (!((ArrayKiteElement)this.element).isNullHidden()) {
            ((ObjectNode)parentProcessor.node).putNull(((ArrayKiteElement)this.element).showNameJSON());
        }
    }

    private void generateArrayStructure(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor, Object[] matchItems) {
        ContentKiteElement contentElement = ((RelevanceKiteElement)this.element).createProxyArrayElement();
        JsonProcessor<? extends KiteElement, ? extends JsonNode> nextProcessor = contentElement.createJsonProcessor(this.jsonProcessContext, (ObjectNode)((ObjectInArrayJsonProcessor)parentProcessor).node);
        nextProcessor.value = matchItems;
        nextProcessor.process(parentProcessor);
    }

    private Object[] forInnerConverter(Object[] valueArray) {
        Optional<String> innerConverterValue = ((RelevanceKiteElement)this.element).getInnerConverterValue();
        if (innerConverterValue.isPresent()) {
            String converterValue = innerConverterValue.get();
            if (converterValue.startsWith("this.")) {
                return Stream.of(valueArray).map(value -> ExpressionUtils.getValue((Object)value, (String)converterValue.substring(5))).toArray(Object[]::new);
            }
            KiteConverter converter = KiteUtils.getComponentInstance(this.jsonProcessContext.getDataModel(), converterValue, KiteConverter.class, "inner-converter");
            return Stream.of(valueArray).map(converter::convert).toArray(Object[]::new);
        }
        return valueArray;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

