/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.ExpressionUtils;
import com.github.developframework.kite.core.dynamic.KiteConverter;
import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.ThisKiteElement;
import com.github.developframework.kite.core.processor.json.ContainerJsonProcessor;
import com.github.developframework.kite.core.processor.json.ContentJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import com.github.developframework.kite.core.utils.KiteUtils;

public class ThisJsonProcessor
extends ContainerJsonProcessor<ThisKiteElement, ObjectNode> {
    public ThisJsonProcessor(JsonProcessContext jsonProcessContext, ThisKiteElement element) {
        super(jsonProcessContext, element);
    }

    @Override
    protected boolean prepare(ContentJsonProcessor<?, ?> parentProcessor) {
        if (((ThisKiteElement)this.element).getConverterValue().isPresent()) {
            String converterValue = ((ThisKiteElement)this.element).getConverterValue().get();
            if (converterValue.startsWith("this.")) {
                this.value = ExpressionUtils.getValue((Object)parentProcessor.value, (String)converterValue.substring(5));
            } else {
                KiteConverter converter = KiteUtils.getComponentInstance(this.jsonProcessContext.getDataModel(), converterValue, KiteConverter.class, "converter");
                this.value = converter.convert(parentProcessor.value);
            }
        } else {
            this.value = parentProcessor.value;
        }
        if (this.value == null && !((ThisKiteElement)this.element).isNullHidden()) {
            ((ObjectNode)parentProcessor.node).putNull(((ThisKiteElement)this.element).showNameJSON());
            return false;
        }
        return true;
    }

    @Override
    protected void handleCoreLogic(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        ContentKiteElement contentElement = KiteUtils.isArrayOrCollection(this.value) ? ((ThisKiteElement)this.element).createProxyArrayElement() : ((ThisKiteElement)this.element).createProxyObjectElement();
        JsonProcessor<? extends KiteElement, ? extends JsonNode> nextProcessor = contentElement.createJsonProcessor(this.jsonProcessContext, (ObjectNode)parentProcessor.node);
        nextProcessor.value = this.value;
        nextProcessor.process(parentProcessor);
    }
}

