/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.xml;

import com.github.developframework.kite.core.element.EnumPropertyKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.xml.ContainerXmlProcessor;
import com.github.developframework.kite.core.processor.xml.ContentXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import java.util.Optional;
import org.dom4j.Element;

public class EnumPropertyXmlProcessor
extends ContainerXmlProcessor<EnumPropertyKiteElement, Element> {
    public EnumPropertyXmlProcessor(XmlProcessContext xmlProcessContext, EnumPropertyKiteElement element) {
        super(xmlProcessContext, element);
    }

    @Override
    protected boolean prepare(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor) {
        Optional<Object> valueOptional = this.getDataValue(parentProcessor);
        if (valueOptional.isPresent()) {
            this.value = valueOptional.get();
            this.node = parentProcessor.node.addElement(((EnumPropertyKiteElement)this.element).showNameXML());
            return true;
        }
        if (!((EnumPropertyKiteElement)this.element).isNullHidden()) {
            this.node = parentProcessor.node.addElement(((EnumPropertyKiteElement)this.element).showNameXML());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor) {
        String enumValue = this.value.toString();
        String enumText = ((EnumPropertyKiteElement)this.element).getEnumText(enumValue);
        if (enumText == null) {
            throw new KiteException("No enum value for \"%s\" in template \"%s\".", enumValue, ((EnumPropertyKiteElement)this.element).getTemplateLocation());
        }
        if (((EnumPropertyKiteElement)this.element).isXmlCdata()) {
            this.node.addCDATA(enumText);
        } else {
            this.node.addText(enumText);
        }
    }
}

