/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.xml;

import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.LinkKiteElement;
import com.github.developframework.kite.core.element.ObjectKiteElement;
import com.github.developframework.kite.core.exception.LinkSizeNotEqualException;
import com.github.developframework.kite.core.processor.xml.ContentXmlProcessor;
import com.github.developframework.kite.core.processor.xml.ObjectInArrayXmlProcessor;
import com.github.developframework.kite.core.processor.xml.ObjectXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.processor.xml.XmlProcessor;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.util.Optional;
import org.dom4j.Element;

public class LinkXmlProcessor
extends ObjectXmlProcessor {
    private int index;

    public LinkXmlProcessor(XmlProcessContext xmlProcessContext, LinkKiteElement element) {
        super(xmlProcessContext, element);
    }

    @Override
    protected boolean prepare(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor) {
        this.index = ((ObjectInArrayXmlProcessor)parentProcessor).getIndex();
        Optional<Object> valueOptional = this.getDataValue(parentProcessor);
        if (valueOptional.isPresent()) {
            Object[] array = KiteUtils.objectToArray(valueOptional.get(), (ContentKiteElement)this.element);
            if (array.length != ((ObjectInArrayXmlProcessor)parentProcessor).getSize()) {
                throw new LinkSizeNotEqualException(((ObjectKiteElement)this.element).getTemplateLocation());
            }
            this.value = array[this.index];
            return true;
        }
        if (!((ObjectKiteElement)this.element).isNullHidden()) {
            this.node.addElement(((ObjectKiteElement)this.element).showNameXML());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor) {
        ContentKiteElement contentElement = ((LinkKiteElement)this.element).createProxyContentElement(this.value.getClass());
        XmlProcessor<? extends KiteElement, ? extends Element> nextProcessor = contentElement.createXmlProcessor(this.xmlProcessContext, ((ObjectInArrayXmlProcessor)parentProcessor).node);
        nextProcessor.setValue(this.value);
        nextProcessor.process(parentProcessor);
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

