/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.xml;

import com.github.developframework.expression.ExpressionUtils;
import com.github.developframework.kite.core.dynamic.KiteConverter;
import com.github.developframework.kite.core.dynamic.RelFunction;
import com.github.developframework.kite.core.element.ArrayKiteElement;
import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.RelevanceKiteElement;
import com.github.developframework.kite.core.processor.xml.ArrayXmlProcessor;
import com.github.developframework.kite.core.processor.xml.ContentXmlProcessor;
import com.github.developframework.kite.core.processor.xml.ObjectInArrayXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.processor.xml.XmlProcessor;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Stream;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelevanceXmlProcessor
extends ArrayXmlProcessor {
    private static final Logger log = LoggerFactory.getLogger(RelevanceXmlProcessor.class);
    private int index;

    public RelevanceXmlProcessor(XmlProcessContext xmlProcessContext, RelevanceKiteElement element) {
        super(xmlProcessContext, element);
    }

    @Override
    protected boolean prepare(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor) {
        this.index = ((ObjectInArrayXmlProcessor)parentProcessor).getIndex();
        Optional<Object> valueOptional = this.getDataValue(parentProcessor);
        if (valueOptional.isPresent()) {
            ObjectInArrayXmlProcessor objectInArrayProcessor = (ObjectInArrayXmlProcessor)parentProcessor;
            RelFunction relFunction = ((RelevanceKiteElement)this.element).getRelFunctionValue().map(relFunctionValue -> KiteUtils.getComponentInstance(this.xmlProcessContext.getDataModel(), relFunctionValue, RelFunction.class, "rel")).get();
            Object[] targets = KiteUtils.objectToArray(valueOptional.get(), (ContentKiteElement)this.element);
            LinkedList<Integer> indexList = new LinkedList<Integer>();
            for (int i2 = 0; i2 < targets.length; ++i2) {
                if (!relFunction.relevant(objectInArrayProcessor.value, this.index, targets[i2], i2)) continue;
                indexList.add(i2);
            }
            this.value = indexList.stream().map(i -> targets[i]).toArray();
            return true;
        }
        if (!((ArrayKiteElement)this.element).isNullHidden()) {
            parentProcessor.getNode().addElement(((ArrayKiteElement)this.element).showNameXML());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor) {
        Object[] valueArray = this.forInnerConverter((Object[])this.value);
        switch (((RelevanceKiteElement)this.element).getRelevanceType()) {
            case AUTO: {
                if (valueArray.length == 1) {
                    this.generateObjectStructure(parentProcessor, valueArray);
                    break;
                }
                this.generateArrayStructure(parentProcessor, valueArray);
                break;
            }
            case SINGLE: {
                if (valueArray.length > 1) {
                    log.warn("You have more items, and you choose relevance type \"SINGLE\".");
                }
                this.generateObjectStructure(parentProcessor, valueArray);
                break;
            }
            case MULTIPLE: {
                this.generateArrayStructure(parentProcessor, valueArray);
            }
        }
    }

    private void generateObjectStructure(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor, Object[] matchItems) {
        if (matchItems.length > 0) {
            ContentKiteElement contentElement = KiteUtils.isArrayOrCollection(matchItems[0]) ? ((RelevanceKiteElement)this.element).createProxyArrayElement() : ((RelevanceKiteElement)this.element).createProxyObjectElement();
            XmlProcessor<? extends KiteElement, ? extends Element> nextProcessor = contentElement.createXmlProcessor(this.xmlProcessContext, null);
            nextProcessor.value = matchItems[0];
            nextProcessor.process(parentProcessor);
        } else if (!((ArrayKiteElement)this.element).isNullHidden()) {
            parentProcessor.getNode().addElement(((ArrayKiteElement)this.element).showNameXML());
        }
    }

    private void generateArrayStructure(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor, Object[] matchItems) {
        ContentKiteElement contentElement = ((RelevanceKiteElement)this.element).createProxyArrayElement();
        XmlProcessor<? extends KiteElement, ? extends Element> nextProcessor = contentElement.createXmlProcessor(this.xmlProcessContext, ((ObjectInArrayXmlProcessor)parentProcessor).node);
        nextProcessor.value = matchItems;
        nextProcessor.process(parentProcessor);
    }

    private Object[] forInnerConverter(Object[] valueArray) {
        Optional<String> innerConverterValue = ((RelevanceKiteElement)this.element).getInnerConverterValue();
        if (innerConverterValue.isPresent()) {
            String converterValue = innerConverterValue.get();
            if (converterValue.startsWith("this.")) {
                return Stream.of(valueArray).map(value -> ExpressionUtils.getValue((Object)value, (String)converterValue.substring(5))).toArray(Object[]::new);
            }
            KiteConverter converter = KiteUtils.getComponentInstance(this.xmlProcessContext.getDataModel(), converterValue, KiteConverter.class, "inner-converter");
            return Stream.of(valueArray).map(converter::convert).toArray(Object[]::new);
        }
        return valueArray;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

