/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.saxparser;

import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.element.ArrayKiteElement;
import com.github.developframework.kite.core.saxparser.ContainerElementSaxParser;
import com.github.developframework.kite.core.saxparser.ParseContext;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;

class ArrayElementSaxParser
extends ContainerElementSaxParser<ArrayKiteElement> {
    ArrayElementSaxParser(KiteConfiguration kiteConfiguration) {
        super(kiteConfiguration);
    }

    @Override
    public String qName() {
        return "array";
    }

    @Override
    protected ArrayKiteElement createElementInstance(ParseContext parseContext, DataDefinition dataDefinition, String alias) {
        return new ArrayKiteElement(this.kiteConfiguration, parseContext.getCurrentTemplateLocation(), dataDefinition, alias);
    }

    @Override
    protected void addOtherAttributes(ArrayKiteElement element, Attributes attributes) {
        int limit;
        super.addOtherAttributes(element, attributes);
        element.setMapFunctionValue(attributes.getValue("map"));
        element.setXmlItemName(attributes.getValue("xml-item"));
        element.setComparatorValue(attributes.getValue("comparator"));
        element.setNullEmpty(attributes.getValue("null-empty"));
        String limitValue = attributes.getValue("limit");
        if (StringUtils.isNumeric((CharSequence)limitValue) && (limit = Integer.parseInt(limitValue)) >= 0) {
            element.setLimit(limit);
        }
    }
}

