/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.mock.db;

import com.github.developframework.mock.MockCache;
import com.github.developframework.mock.MockTask;
import com.github.developframework.mock.RandomGeneratorRegistry;
import com.github.developframework.mock.db.DBInfo;
import com.github.developframework.mock.db.DBMockException;
import com.github.developframework.mock.db.InsertSQLSubmitter;
import develop.framework.components.KeyValuePair;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlInsertSQLSubmitter
extends InsertSQLSubmitter {
    private static final Logger log = LoggerFactory.getLogger(MysqlInsertSQLSubmitter.class);

    public MysqlInsertSQLSubmitter(RandomGeneratorRegistry randomGeneratorRegistry, MockCache cache, DBInfo dbInfo) {
        super(randomGeneratorRegistry, cache, dbInfo);
    }

    private String build() {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        if (this.database != null) {
            sb.append("`").append(this.database).append("`.");
        }
        if (this.table == null) {
            throw new DBMockException("table is undefined");
        }
        sb.append('`').append(this.table).append("`(");
        if (this.fields.isEmpty()) {
            throw new DBMockException("fields is empty.");
        }
        sb.append(StringUtils.join((Iterable)this.fields.stream().map(pair -> "`" + (String)pair.getKey() + "`").collect(Collectors.toList()), (String)", "));
        sb.append(") VALUES(");
        sb.append(StringUtils.join((Iterable)this.fields.stream().map(pair -> "?").collect(Collectors.toList()), (String)", "));
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int submit(int quantity) throws SQLException {
        try {
            Class.forName(this.dbInfo.getDriver());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Connection connection = DriverManager.getConnection(this.dbInfo.getUrl(), this.dbInfo.getUser(), this.dbInfo.getPassword());
        connection.setAutoCommit(false);
        String sql = this.build();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        int r = 0;
        try {
            for (int i = 0; i < quantity; ++i) {
                LinkedList<String> values = new LinkedList<String>();
                for (int j = 0; j < this.fields.size(); ++j) {
                    MockTask mockTask = (MockTask)((KeyValuePair)this.fields.get(j)).getValue();
                    String value = mockTask.run();
                    values.add(value);
                    preparedStatement.setString(j + 1, value);
                }
                r += preparedStatement.executeUpdate();
                log.debug(sql + "\n=> Values\uff1a " + String.join((CharSequence)", ", values));
            }
        }
        catch (Exception e) {
            connection.rollback();
            throw new DBMockException(e.getMessage());
        }
        connection.commit();
        preparedStatement.close();
        connection.close();
        return r;
    }
}

