/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.mock;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class MockPlaceholder {
    private String placeholder;
    private String name;
    private Map<String, Object> parameters;

    public MockPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        String content = placeholder.substring(2, placeholder.length() - 1).trim();
        if (content.contains("|")) {
            String[] fragments = content.split("\\s*\\|\\s*");
            this.name = fragments[0].trim();
            this.parameters = fragments.length > 1 ? this.createParameters(fragments[1].trim()) : Collections.emptyMap();
        } else {
            this.name = content;
            this.parameters = Collections.emptyMap();
        }
    }

    private Map<String, Object> createParameters(String parameterFragment) {
        String[] parameterArray;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String parameterStr : parameterArray = parameterFragment.split(",")) {
            if (parameterStr.contains("=")) {
                String[] split = parameterStr.split("=");
                map.put(split[0].trim(), this.guessType(split[1].trim()));
                continue;
            }
            map.put(parameterStr.trim(), true);
        }
        return map;
    }

    private Object guessType(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        if (value.matches("^'.*'$")) {
            return value.substring(1, value.length() - 1);
        }
        if (value.matches("^\\d+$")) {
            return Integer.valueOf(value);
        }
        if (value.matches("^\\d+\\.\\d+$")) {
            return Double.valueOf(value);
        }
        if (value.equals("true") || value.equals("false")) {
            return Boolean.valueOf(value);
        }
        return value;
    }

    public <T> Optional<T> getParameter(String name, Class<T> clazz) {
        Object obj = this.parameters.get(name);
        return obj == null ? Optional.empty() : Optional.of(obj);
    }

    public <T> T getParameterOrDefault(String name, Class<T> clazz, T defValue) {
        Object obj = this.parameters.get(name);
        return (T)(obj == null ? defValue : obj);
    }

    public Optional<String> getId() {
        return this.getParameter("id", String.class);
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

