/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.mock;

import com.github.developframework.mock.MockCache;
import com.github.developframework.mock.MockPlaceholder;
import com.github.developframework.mock.RandomGeneratorRegistry;
import com.github.developframework.mock.random.RandomGenerator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MockTask {
    private static final String REGEX = "(?=\\$\\{)(.*?)(?<=\\})";
    private RandomGeneratorRegistry randomGeneratorRegistry;
    private String template;
    private MockCache cache;

    public MockTask(RandomGeneratorRegistry randomGeneratorRegistry, MockCache cache, String template) {
        this.randomGeneratorRegistry = randomGeneratorRegistry;
        this.cache = cache;
        this.template = template;
    }

    public String run() {
        List<MockPlaceholder> mockPlaceholders = this.extractPlaceholder(this.template);
        String result = this.template;
        for (MockPlaceholder mockPlaceholder : mockPlaceholders) {
            RandomGenerator randomGenerator = this.randomGeneratorRegistry.getRandomGenerator(mockPlaceholder.getName());
            Optional<String> idOptional = mockPlaceholder.getId();
            Object value = randomGenerator.randomValue(this.randomGeneratorRegistry, mockPlaceholder, this.cache);
            if (idOptional.isPresent()) {
                this.cache.put(idOptional.get(), new MockCache.Cache(value, mockPlaceholder));
            }
            String stringValue = randomGenerator.forString(mockPlaceholder, value);
            result = result.replace(mockPlaceholder.getPlaceholder(), stringValue);
        }
        return result;
    }

    private List<MockPlaceholder> extractPlaceholder(String template) {
        LinkedList<MockPlaceholder> list = new LinkedList<MockPlaceholder>();
        Pattern pattern = Pattern.compile(REGEX);
        Matcher m = pattern.matcher(template);
        while (m.find()) {
            list.add(new MockPlaceholder(m.group()));
        }
        return list;
    }
}

