/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.mock.random;

import com.github.developframework.mock.MockCache;
import com.github.developframework.mock.MockException;
import com.github.developframework.mock.MockPlaceholder;
import com.github.developframework.mock.RandomGeneratorRegistry;
import com.github.developframework.mock.random.RandomGenerator;
import com.github.developframework.regiondata.ChinaRegionProvider;
import com.github.developframework.regiondata.City;
import com.github.developframework.regiondata.County;
import com.github.developframework.regiondata.Province;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.RandomUtils;

public class AddressRandomGenerator
implements RandomGenerator<County> {
    private static final String PARAMETER_LEVEL = "level";
    private static final String PARAMETER_PROVINCE = "province";
    private static final String PARAMETER_CITY = "city";
    private static ChinaRegionProvider chinaRegionProvider = new ChinaRegionProvider();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public County randomValue(RandomGeneratorRegistry randomGeneratorRegistry, MockPlaceholder mockPlaceholder, MockCache mockCache) {
        List counties;
        Optional<String> provinceOptional = mockPlaceholder.getParameter(PARAMETER_PROVINCE, String.class);
        if (provinceOptional.isPresent()) {
            Optional provinceByName = chinaRegionProvider.getChina().getProvinceByName(provinceOptional.get());
            if (!provinceByName.isPresent()) throw new MockException("address random generator province attribute \"%s\" value is not exist.", provinceOptional.get());
            Optional<String> cityOptional = mockPlaceholder.getParameter(PARAMETER_CITY, String.class);
            if (cityOptional.isPresent()) {
                Optional cityByName = ((Province)provinceByName.get()).getCityByName(cityOptional.get());
                if (!cityByName.isPresent()) throw new MockException("address random generator city attribute \"%s\" value is not exist.", cityOptional.get());
                counties = ((City)cityByName.get()).getAllCounties();
                return (County)counties.get(RandomUtils.nextInt((int)0, (int)counties.size()));
            } else {
                counties = ((Province)provinceByName.get()).getAllCounties();
            }
            return (County)counties.get(RandomUtils.nextInt((int)0, (int)counties.size()));
        } else {
            counties = chinaRegionProvider.getChina().getAllCounties();
        }
        return (County)counties.get(RandomUtils.nextInt((int)0, (int)counties.size()));
    }

    public String key() {
        return "address";
    }

    @Override
    public String forString(MockPlaceholder mockPlaceholder, County value) {
        String address;
        int level = mockPlaceholder.getParameterOrDefault(PARAMETER_LEVEL, Integer.TYPE, 3);
        switch (level) {
            case 1: {
                address = value.getCity().getProvince().getName();
                break;
            }
            case 2: {
                address = value.getCity().getProvince().getName() + value.getCity().getName();
                break;
            }
            default: {
                address = value.getCity().getProvince().getName() + value.getCity().getName() + value.getName();
            }
        }
        return address;
    }
}

