/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.mock.random;

import com.github.developframework.mock.MockCache;
import com.github.developframework.mock.MockException;
import com.github.developframework.mock.MockPlaceholder;
import com.github.developframework.mock.RandomGeneratorRegistry;
import com.github.developframework.mock.random.RandomGenerator;
import java.util.Date;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateTimeRandomGenerator
implements RandomGenerator<Date> {
    protected static final String PARAMETER_RANGE = "range";
    protected static final String PARAMETER_FUTURE = "future";
    protected static final String PARAMETER_PATTERN = "pattern";

    @Override
    public Date randomValue(RandomGeneratorRegistry randomGeneratorRegistry, MockPlaceholder mockPlaceholder, MockCache cache) {
        String range = mockPlaceholder.getParameterOrDefault(PARAMETER_RANGE, String.class, "1y");
        boolean future = mockPlaceholder.getParameterOrDefault(PARAMETER_FUTURE, Boolean.TYPE, false);
        long max = this.calcRange(range);
        long d = RandomUtils.nextLong((long)1000L, (long)max);
        long dateLong = System.currentTimeMillis() + (future ? d : -d);
        return new Date(dateLong);
    }

    public String key() {
        return "datetime";
    }

    @Override
    public String forString(MockPlaceholder mockPlaceholder, Date value) {
        String pattern = mockPlaceholder.getParameterOrDefault(PARAMETER_PATTERN, String.class, "yyyy-MM-dd HH:mm:ss");
        return DateFormatUtils.format((Date)value, (String)pattern);
    }

    protected long calcRange(String range) {
        if (range.matches("^(\\d+y)?(\\d+M)?(\\d+d)?(\\d+h)?(\\d+m)?(\\d+s)?$")) {
            int temp = 0;
            long sum = 0L;
            block8: for (int i = 0; i < range.length(); ++i) {
                char ch = range.charAt(i);
                if (ch >= '0' && ch <= '9') {
                    temp = temp * 10 + (ch - 48);
                }
                switch (ch) {
                    case 'y': {
                        sum += (long)(temp * 365 * 24 * 3600);
                        continue block8;
                    }
                    case 'M': {
                        sum += (long)(temp * 30 * 24 * 3600);
                        continue block8;
                    }
                    case 'd': {
                        sum += (long)(temp * 24 * 3600);
                        continue block8;
                    }
                    case 'h': {
                        sum += (long)(temp * 3600);
                        continue block8;
                    }
                    case 'm': {
                        sum += (long)(temp * 60);
                        continue block8;
                    }
                    case 's': {
                        sum += (long)temp;
                    }
                }
            }
            return sum * 1000L;
        }
        throw new MockException("range format error");
    }
}

