/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.mock.random;

import com.github.developframework.mock.MockCache;
import com.github.developframework.mock.MockException;
import com.github.developframework.mock.MockPlaceholder;
import com.github.developframework.mock.RandomGeneratorRegistry;
import com.github.developframework.mock.random.RandomGenerator;
import java.util.Optional;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

public class IPRandomGenerator
implements RandomGenerator<String> {
    private static final String PARAMETER_PREFIX = "prefix";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String randomValue(RandomGeneratorRegistry randomGeneratorRegistry, MockPlaceholder mockPlaceholder, MockCache mockCache) {
        int needNumberCount;
        String prefix;
        Optional<String> prefixOptional = mockPlaceholder.getParameter(PARAMETER_PREFIX, String.class);
        if (prefixOptional.isPresent()) {
            prefix = prefixOptional.get();
            if (!prefix.matches("^(([1-9]?\\d|1\\d{2}|(2([0-4]\\d|5[0-5])))\\.){0,2}([1-9]?\\d|1\\d{2}|(2([0-4]\\d|5[0-5])))$")) throw new MockException("\"%s\" is not a valid IP prefix", prefix);
            needNumberCount = 4 - prefix.split("\\.").length;
        } else {
            prefix = "";
            needNumberCount = 4;
        }
        int[] numbers = new int[needNumberCount];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = RandomUtils.nextInt((int)0, (int)256);
        }
        return prefix + "." + StringUtils.join((int[])numbers, (char)'.');
    }

    public String key() {
        return "ip";
    }

    @Override
    public String forString(MockPlaceholder mockPlaceholder, String value) {
        return value;
    }
}

