/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.mock.random;

import com.github.developframework.mock.MockCache;
import com.github.developframework.mock.MockException;
import com.github.developframework.mock.MockPlaceholder;
import com.github.developframework.mock.RandomGeneratorRegistry;
import com.github.developframework.mock.random.RandomGenerator;
import com.github.developframework.regiondata.County;
import java.util.Date;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class IdentityCardRandomGenerator
implements RandomGenerator<IdentityCard> {
    private static final String PARAMETER_ADDRESS_REF = "address-ref";
    private static final String PARAMETER_BIRTHDAY_REF = "birthday-ref";
    private static final String PARAMETER_SEX_REF = "sex-ref";
    private static final String PARAMETER_RANGE = "range";

    @Override
    public IdentityCard randomValue(RandomGeneratorRegistry randomGeneratorRegistry, MockPlaceholder mockPlaceholder, MockCache mockCache) {
        County address = this.getAddress(randomGeneratorRegistry, mockPlaceholder, mockCache);
        Date birthday = this.getBirthday(randomGeneratorRegistry, mockPlaceholder, mockCache);
        int number = this.getNumber(randomGeneratorRegistry, mockPlaceholder, mockCache);
        return new IdentityCard(address, birthday, number);
    }

    public String key() {
        return "identityCard";
    }

    @Override
    public String forString(MockPlaceholder mockPlaceholder, IdentityCard value) {
        return value.toString();
    }

    private County getAddress(RandomGeneratorRegistry randomGeneratorRegistry, MockPlaceholder mockPlaceholder, MockCache mockCache) {
        String addressRef = mockPlaceholder.getParameterOrDefault(PARAMETER_ADDRESS_REF, String.class, "random");
        if (addressRef.equals("random")) {
            RandomGenerator addressRandomGenerator = randomGeneratorRegistry.getRandomGenerator("address");
            MockPlaceholder addressMockPlaceholder = new MockPlaceholder("${ address }");
            return (County)addressRandomGenerator.randomValue(randomGeneratorRegistry, addressMockPlaceholder, mockCache);
        }
        MockCache.Cache cache = (MockCache.Cache)mockCache.get(addressRef);
        if (cache == null) {
            throw new MockException("identityCard address-ref \"%s\" value is undefined.", addressRef);
        }
        Object value = cache.getValue();
        if (value instanceof County) {
            return (County)cache.getValue();
        }
        throw new MockException("identityCard address-ref \"%s\" value is not a java.util.Date instance.", addressRef);
    }

    private Date getBirthday(RandomGeneratorRegistry randomGeneratorRegistry, MockPlaceholder mockPlaceholder, MockCache mockCache) {
        String birthdayRef = mockPlaceholder.getParameterOrDefault(PARAMETER_BIRTHDAY_REF, String.class, "random");
        String range = mockPlaceholder.getParameterOrDefault(PARAMETER_RANGE, String.class, "30y");
        if (birthdayRef.equals("random")) {
            RandomGenerator dateRandomGenerator = randomGeneratorRegistry.getRandomGenerator("date");
            MockPlaceholder dateMockPlaceholder = new MockPlaceholder("${ date | range = " + range + " }");
            return (Date)dateRandomGenerator.randomValue(randomGeneratorRegistry, dateMockPlaceholder, mockCache);
        }
        MockCache.Cache cache = (MockCache.Cache)mockCache.get(birthdayRef);
        if (cache == null) {
            throw new MockException("identityCard birthday-ref \"%s\" value is undefined.", birthdayRef);
        }
        Object value = cache.getValue();
        if (value instanceof Date) {
            return (Date)cache.getValue();
        }
        throw new MockException("identityCard birthday-ref \"%s\" value is not a java.util.Date instance.", birthdayRef);
    }

    private int getNumber(RandomGeneratorRegistry randomGeneratorRegistry, MockPlaceholder mockPlaceholder, MockCache mockCache) {
        int[] nArray;
        String sexRef = mockPlaceholder.getParameterOrDefault(PARAMETER_SEX_REF, String.class, "random");
        if (sexRef.equals("random")) {
            return RandomUtils.nextInt((int)0, (int)100);
        }
        if (sexRef.equals("FEMALE")) {
            int[] nArray2 = new int[5];
            nArray2[0] = 0;
            nArray2[1] = 2;
            nArray2[2] = 4;
            nArray2[3] = 6;
            nArray = nArray2;
            nArray2[4] = 8;
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = 1;
            nArray3[1] = 3;
            nArray3[2] = 5;
            nArray3[3] = 7;
            nArray = nArray3;
            nArray3[4] = 9;
        }
        int[] femaleNumber = nArray;
        return RandomUtils.nextInt((int)0, (int)9) + femaleNumber[RandomUtils.nextInt((int)0, (int)5)];
    }

    public static class IdentityCard {
        private County address;
        private Date birthday;
        private int number;
        private char lastCode;

        public IdentityCard(County address, Date birthday, int number) {
            this.address = address;
            this.birthday = birthday;
            this.number = number;
            String front17Chars = address.getCode() + DateFormatUtils.format((Date)birthday, (String)"yyyyMMdd") + String.format("%03d", number);
            this.lastCode = this.computeLastCode(front17Chars);
        }

        public String toString() {
            return this.address.getCode() + DateFormatUtils.format((Date)this.birthday, (String)"yyyyMMdd") + String.format("%03d", this.number) + this.lastCode;
        }

        private char computeLastCode(String front17Chars) {
            int[] VERIFY_NUMBERS = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
            char[] TARGET_CHARS = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
            int sum = 0;
            for (int i = 0; i < front17Chars.length(); ++i) {
                sum += (front17Chars.charAt(i) - 48) * VERIFY_NUMBERS[i];
            }
            return TARGET_CHARS[sum % 11];
        }

        public County getAddress() {
            return this.address;
        }

        public Date getBirthday() {
            return this.birthday;
        }

        public int getNumber() {
            return this.number;
        }

        public char getLastCode() {
            return this.lastCode;
        }
    }
}

