/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.mock.random;

import com.github.developframework.mock.MockCache;
import com.github.developframework.mock.MockException;
import com.github.developframework.mock.MockPlaceholder;
import com.github.developframework.mock.RandomGeneratorRegistry;
import com.github.developframework.mock.random.RandomGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomUtils;

public class PersonNameRandomGenerator
implements RandomGenerator<String> {
    private static final String PARAMETER_LENGTH = "length";
    private static final String PARAMETER_ONLY_NAME = "onlyName";
    private static final String PARAMETER_SEX = "sex";
    private String[] familyNameLib;
    private String[] maleNameLib;
    private String[] femaleNameLib;

    public PersonNameRandomGenerator() {
        LinkedList<String> familyNameList = new LinkedList<String>();
        LinkedList<String> maleNameList = new LinkedList<String>();
        LinkedList<String> femaleNameList = new LinkedList<String>();
        int flag = 0;
        try (InputStream is = this.getClass().getResourceAsStream("/person_name_chinese.txt");){
            List list = IOUtils.readLines((InputStream)is, (Charset)Charset.forName("UTF-8"));
            for (String line : list) {
                if (line.startsWith("--")) {
                    ++flag;
                    continue;
                }
                String[] words = line.split("");
                switch (flag) {
                    case 0: {
                        familyNameList.addAll(Arrays.asList(words));
                        break;
                    }
                    case 1: {
                        maleNameList.addAll(Arrays.asList(words));
                        break;
                    }
                    case 2: {
                        femaleNameList.addAll(Arrays.asList(words));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MockException("mock client read resource \"person_name_chinese.txt\" failed, " + e.getMessage());
        }
        this.familyNameLib = familyNameList.toArray(new String[familyNameList.size()]);
        this.maleNameLib = maleNameList.toArray(new String[maleNameList.size()]);
        this.femaleNameLib = femaleNameList.toArray(new String[femaleNameList.size()]);
    }

    @Override
    public String randomValue(RandomGeneratorRegistry randomGeneratorRegistry, MockPlaceholder mockPlaceholder, MockCache cache) {
        String sex;
        int length = mockPlaceholder.getParameterOrDefault(PARAMETER_LENGTH, Integer.class, RandomUtils.nextBoolean() ? 3 : 2);
        if (length < 2) {
            throw new MockException("person name least 2 words.");
        }
        boolean isOnlyName = mockPlaceholder.getParameterOrDefault(PARAMETER_ONLY_NAME, Boolean.TYPE, false);
        switch (sex = mockPlaceholder.getParameterOrDefault(PARAMETER_SEX, String.class, "UNKNOWN")) {
            case "MALE": {
                boolean bl = true;
            }
            case "FEMALE": {
                boolean bl = false;
            }
        }
        boolean isMale = RandomUtils.nextBoolean();
        String r = isOnlyName ? "" : this.familyNameLib[RandomUtils.nextInt((int)0, (int)this.familyNameLib.length)];
        for (int i = 0; i < length - 1; ++i) {
            r = isMale ? r + this.maleNameLib[RandomUtils.nextInt((int)0, (int)this.maleNameLib.length)] : r + this.femaleNameLib[RandomUtils.nextInt((int)0, (int)this.femaleNameLib.length)];
        }
        return r;
    }

    public String key() {
        return "personName";
    }

    @Override
    public String forString(MockPlaceholder mockPlaceholder, String value) {
        return value;
    }
}

