/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.mock.random;

import com.github.developframework.mock.MockCache;
import com.github.developframework.mock.MockPlaceholder;
import com.github.developframework.mock.RandomGeneratorRegistry;
import com.github.developframework.mock.random.RandomGenerator;
import org.apache.commons.lang3.RandomStringUtils;

public class StringRandomGenerator
implements RandomGenerator<String> {
    private static final String PARAMETER_LENGTH = "length";
    private static final String PARAMETER_UPPERCASE = "uppercase";
    private static final String PARAMETER_LOWERCASE = "lowercase";
    private static final String PARAMETER_LETTERS = "letters";
    private static final String PARAMETER_NUMBERS = "numbers";

    @Override
    public String randomValue(RandomGeneratorRegistry randomGeneratorRegistry, MockPlaceholder mockPlaceholder, MockCache cache) {
        int length = mockPlaceholder.getParameterOrDefault(PARAMETER_LENGTH, Integer.TYPE, 6);
        boolean uppercase = mockPlaceholder.getParameterOrDefault(PARAMETER_UPPERCASE, Boolean.TYPE, false);
        boolean lowercase = mockPlaceholder.getParameterOrDefault(PARAMETER_LOWERCASE, Boolean.TYPE, false);
        boolean letters = mockPlaceholder.getParameterOrDefault(PARAMETER_LETTERS, Boolean.TYPE, false);
        boolean numbers = mockPlaceholder.getParameterOrDefault(PARAMETER_NUMBERS, Boolean.TYPE, false);
        if (!letters && !numbers) {
            letters = true;
        }
        String result = RandomStringUtils.random((int)length, (boolean)letters, (boolean)numbers);
        if (uppercase == lowercase) {
            return result;
        }
        if (uppercase) {
            return result.toUpperCase();
        }
        if (lowercase) {
            return result.toLowerCase();
        }
        return result;
    }

    public String key() {
        return "string";
    }

    @Override
    public String forString(MockPlaceholder mockPlaceholder, String value) {
        return value;
    }
}

