/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.mock.random;

import com.github.developframework.mock.MockCache;
import com.github.developframework.mock.MockPlaceholder;
import com.github.developframework.mock.RandomGeneratorRegistry;
import com.github.developframework.mock.random.DateTimeRandomGenerator;
import java.util.Date;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class TimeRandomGenerator
extends DateTimeRandomGenerator {
    @Override
    public Date randomValue(RandomGeneratorRegistry randomGeneratorRegistry, MockPlaceholder mockPlaceholder, MockCache mockCache) {
        String range = mockPlaceholder.getParameterOrDefault("range", String.class, "1h");
        boolean future = mockPlaceholder.getParameterOrDefault("future", Boolean.TYPE, false);
        long max = this.calcRange(range);
        long d = RandomUtils.nextLong((long)1000L, (long)max);
        long dateLong = System.currentTimeMillis() + (future ? d : -d);
        return new Date(dateLong);
    }

    @Override
    public String key() {
        return "time";
    }

    @Override
    public String forString(MockPlaceholder mockPlaceholder, Date value) {
        String pattern = mockPlaceholder.getParameterOrDefault("pattern", String.class, "HH:mm:ss");
        return DateFormatUtils.format((Date)value, (String)pattern);
    }
}

