/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.toolkit.persistence.component;

import com.github.developframework.toolkit.base.Toolkit;
import com.github.developframework.toolkit.persistence.component.Range;
import com.github.developframework.toolkit.persistence.exception.RangeException;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public class DateRange
extends Range<Date> {
    public static final DateRange parse(String fromDateStr, String toDateStr, String pattern) {
        Date to;
        Date from;
        try {
            from = (Date)Toolkit.useElseDefault((Object)DateUtils.parseDate((String)fromDateStr, (String[])new String[]{pattern}), null);
        }
        catch (ParseException e) {
            throw new RangeException(String.format("\"%s\" invalid.", fromDateStr));
        }
        try {
            to = (Date)Toolkit.useElseDefault((Object)DateUtils.parseDate((String)toDateStr, (String[])new String[]{pattern}), null);
        }
        catch (ParseException e) {
            throw new RangeException(String.format("\"%s\" invalid.", fromDateStr));
        }
        return new DateRange(from, to);
    }

    private DateRange(Date from, Date to) {
        super(from, to);
    }
}

