/*
 * Decompiled with CFR 0.152.
 */
package com.github.devgcoder.devgmethod.model;

import java.io.Serializable;

public class ResultModel<T>
implements Serializable {
    private static final String successMessage = "\u64cd\u4f5c\u6210\u529f";
    private static final String errorMessage = "\u7cfb\u7edf\u7e41\u5fd9";
    private boolean success = false;
    private int code;
    private String message = "";
    private T data;

    public static <T> ResultModel<T> newSuccess() {
        return new ResultModel<Object>().setData(null).setSuccess(true).setMessage(successMessage).setCode(1);
    }

    public static <T> ResultModel<T> newSuccess(T data) {
        return new ResultModel<T>().setData(data).setSuccess(true).setMessage(successMessage).setCode(1);
    }

    public static <T> ResultModel<T> newFail(String message) {
        return new ResultModel<T>().setMessage(message).setSuccess(false).setData(null).setCode(0);
    }

    public static <T> ResultModel<T> newFail(int code, String message) {
        return new ResultModel<T>().setMessage(message).setSuccess(false).setData(null).setCode(code);
    }

    public static <T> ResultModel<T> newFail() {
        return ResultModel.newFail(errorMessage);
    }

    public static <T> ResultModel<T> newFail(int code) {
        return ResultModel.newFail(code, errorMessage);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ResultModel<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public int getCode() {
        return this.code;
    }

    public ResultModel<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public ResultModel<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public ResultModel<T> setData(T data) {
        this.data = data;
        return this;
    }
}

