/*
 * Decompiled with CFR 0.152.
 */
package com.github.devgcoder.devgmethod.utils.async;

import com.github.devgcoder.devgmethod.utils.async.FutureTaskResult;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncUtil {
    private static final Logger log = LoggerFactory.getLogger(AsyncUtil.class);
    private static final Integer blockingQueueNum = 50;
    private ExecutorService executorService;
    private Map<String, Future> futureTaskMap;

    public AsyncUtil() {
        this.executorService = new ThreadPoolExecutor(10, 100, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(blockingQueueNum), new ThreadPoolExecutor.DiscardPolicy());
        this.futureTaskMap = new HashMap<String, Future>();
    }

    public AsyncUtil(int threadPoolNum) {
        this.executorService = new ThreadPoolExecutor(threadPoolNum, threadPoolNum, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(blockingQueueNum), new ThreadPoolExecutor.DiscardPolicy());
        this.futureTaskMap = new HashMap<String, Future>();
    }

    public AsyncUtil(ExecutorService executorService) {
        this.executorService = executorService;
        this.futureTaskMap = new HashMap<String, Future>();
    }

    public static AsyncUtil newInstance() {
        return AsyncUtil.newInstance(4);
    }

    public static AsyncUtil newInstance(int threadPoolNum) {
        return new AsyncUtil(threadPoolNum);
    }

    public void addExecutePool(String key, final Object serviceObj, final String methodName, final Object[] params, final Class<?> ... parameterTypes) {
        FutureTask<FutureTaskResult<Object>> ft1 = new FutureTask<FutureTaskResult<Object>>(new Callable<FutureTaskResult<Object>>(){

            @Override
            public FutureTaskResult<Object> call() throws Exception {
                Method md = serviceObj.getClass().getMethod(methodName, parameterTypes);
                Object obj = md.invoke(serviceObj, params);
                FutureTaskResult<Object> futureTaskResult = new FutureTaskResult<Object>();
                futureTaskResult.setData(obj);
                futureTaskResult.setKey(methodName);
                return futureTaskResult;
            }
        });
        this.futureTaskMap.put(key, ft1);
        this.executorService.execute(ft1);
    }

    public <T> T getResult(String key) {
        try {
            Future future = this.futureTaskMap.get(key);
            Object obj = future.get();
            FutureTaskResult result = (FutureTaskResult)obj;
            return result.getData();
        }
        catch (InterruptedException ex) {
            log.error("async task InterruptedException", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            log.error("async task ExecutionException", (Throwable)ex);
        }
        return null;
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

