/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.core.AbstractDockerCmdExecFactory;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.jaxrs.JerseyWebTarget;
import com.github.dockerjava.jaxrs.UnixConnectionSocketFactory;
import com.github.dockerjava.jaxrs.filter.JsonClientFilter;
import com.github.dockerjava.jaxrs.filter.ResponseStatusExceptionFilter;
import com.github.dockerjava.jaxrs.filter.SelectiveLoggingFilter;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Configuration;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyDockerCmdExecFactory
extends AbstractDockerCmdExecFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JerseyDockerCmdExecFactory.class.getName());
    private Client client;
    private JerseyWebTarget baseResource;
    private Integer readTimeout = null;
    private Integer connectTimeout = null;
    private Integer maxTotalConnections = null;
    private Integer maxPerRouteConnections = null;
    private Integer connectionRequestTimeout = null;
    private ClientRequestFilter[] clientRequestFilters = null;
    private ClientResponseFilter[] clientResponseFilters = null;
    private DockerClientConfig dockerClientConfig;
    private PoolingHttpClientConnectionManager connManager = null;
    private RequestEntityProcessing requestEntityProcessing;

    public void init(DockerClientConfig dockerClientConfig) {
        Preconditions.checkNotNull((Object)dockerClientConfig, (Object)"config was not specified");
        this.dockerClientConfig = dockerClientConfig;
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        clientConfig.property("jersey.config.disableAutoDiscovery", (Object)true);
        if (this.requestEntityProcessing != null) {
            clientConfig.property("jersey.config.client.request.entity.processing", (Object)this.requestEntityProcessing);
        }
        clientConfig.register((Object)new ResponseStatusExceptionFilter(dockerClientConfig.getObjectMapper()));
        clientConfig.register(JsonClientFilter.class);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        clientConfig.register((Object)new JacksonJsonProvider(dockerClientConfig.getObjectMapper()));
        clientConfig.register((Object)new SelectiveLoggingFilter(LOGGER, true));
        if (this.readTimeout != null) {
            requestConfigBuilder.setSocketTimeout(this.readTimeout.intValue());
            clientConfig.property("jersey.config.client.readTimeout", (Object)this.readTimeout);
        }
        if (this.connectTimeout != null) {
            requestConfigBuilder.setConnectTimeout(this.connectTimeout.intValue());
            clientConfig.property("jersey.config.client.connectTimeout", (Object)this.connectTimeout);
        }
        if (this.clientResponseFilters != null) {
            for (ClientResponseFilter clientResponseFilter : this.clientResponseFilters) {
                if (clientResponseFilter == null) continue;
                clientConfig.register((Object)clientResponseFilter);
            }
        }
        if (this.clientRequestFilters != null) {
            for (ClientResponseFilter clientResponseFilter : this.clientRequestFilters) {
                if (clientResponseFilter == null) continue;
                clientConfig.register((Object)clientResponseFilter);
            }
        }
        URI originalUri = dockerClientConfig.getDockerHost();
        String protocol = null;
        SSLContext sslContext = null;
        try {
            SSLConfig sSLConfig = dockerClientConfig.getSSLConfig();
            if (sSLConfig != null) {
                sslContext = sSLConfig.getSSLContext();
            }
        }
        catch (Exception exception) {
            throw new DockerClientException("Error in SSL Configuration", (Throwable)exception);
        }
        protocol = sslContext != null ? "https" : "http";
        switch (originalUri.getScheme()) {
            case "unix": {
                break;
            }
            case "tcp": {
                try {
                    originalUri = new URI(originalUri.toString().replaceFirst("tcp", protocol));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                this.configureProxy(clientConfig, originalUri, protocol);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported protocol scheme: " + originalUri);
            }
        }
        this.connManager = new PoolingHttpClientConnectionManager(this.getSchemeRegistry(originalUri, sslContext)){

            public void close() {
                super.shutdown();
            }

            public void shutdown() {
            }
        };
        if (this.maxTotalConnections != null) {
            this.connManager.setMaxTotal(this.maxTotalConnections.intValue());
        }
        if (this.maxPerRouteConnections != null) {
            this.connManager.setDefaultMaxPerRoute(this.maxPerRouteConnections.intValue());
        }
        clientConfig.property("jersey.config.apache.client.connectionManager", (Object)this.connManager);
        if (this.connectionRequestTimeout != null) {
            requestConfigBuilder.setConnectionRequestTimeout(this.connectionRequestTimeout.intValue());
        }
        clientConfig.property("jersey.config.apache.client.requestConfig", (Object)requestConfigBuilder.build());
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)clientConfig);
        if (sslContext != null) {
            clientBuilder.sslContext(sslContext);
        }
        this.client = clientBuilder.build();
        this.baseResource = new JerseyWebTarget(dockerClientConfig.getObjectMapper(), this.client.target(this.sanitizeUrl(originalUri).toString()).path(dockerClientConfig.getApiVersion().asWebPathPart()));
        super.init(dockerClientConfig);
    }

    private URI sanitizeUrl(URI originalUri) {
        if (originalUri.getScheme().equals("unix")) {
            return UnixConnectionSocketFactory.sanitizeUri(originalUri);
        }
        return originalUri;
    }

    private void configureProxy(ClientConfig clientConfig, URI originalUri, String protocol) {
        List<Proxy> proxies = ProxySelector.getDefault().select(originalUri);
        for (Proxy proxy : proxies) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            if (address == null) continue;
            String hostname = address.getHostName();
            int port = address.getPort();
            clientConfig.property("jersey.config.client.proxy.uri", (Object)("http://" + hostname + ":" + port));
            String httpProxyUser = System.getProperty(protocol + ".proxyUser");
            if (httpProxyUser == null) continue;
            clientConfig.property("jersey.config.client.proxy.username", (Object)httpProxyUser);
            String httpProxyPassword = System.getProperty(protocol + ".proxyPassword");
            if (httpProxyPassword == null) continue;
            clientConfig.property("jersey.config.client.proxy.password", (Object)httpProxyPassword);
        }
    }

    private Registry<ConnectionSocketFactory> getSchemeRegistry(URI originalUri, SSLContext sslContext) {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        registryBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        if (sslContext != null) {
            registryBuilder.register("https", (Object)new SSLConnectionSocketFactory(sslContext));
        }
        registryBuilder.register("unix", (Object)new UnixConnectionSocketFactory(originalUri));
        return registryBuilder.build();
    }

    protected JerseyWebTarget getBaseResource() {
        Preconditions.checkNotNull((Object)this.baseResource, (Object)"Factory not initialized, baseResource not set. You probably forgot to call init()!");
        return this.baseResource;
    }

    protected DockerClientConfig getDockerClientConfig() {
        Preconditions.checkNotNull((Object)this.dockerClientConfig, (Object)"Factor not initialized, dockerClientConfig not set. You probably forgot to call init()!");
        return this.dockerClientConfig;
    }

    public void close() throws IOException {
        Preconditions.checkNotNull((Object)this.client, (Object)"Factory not initialized. You probably forgot to call init()!");
        this.client.close();
        this.connManager.close();
    }

    public JerseyDockerCmdExecFactory withReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public JerseyDockerCmdExecFactory withConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public JerseyDockerCmdExecFactory withMaxTotalConnections(Integer maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
        return this;
    }

    public JerseyDockerCmdExecFactory withMaxPerRouteConnections(Integer maxPerRouteConnections) {
        this.maxPerRouteConnections = maxPerRouteConnections;
        return this;
    }

    public JerseyDockerCmdExecFactory withConnectionRequestTimeout(Integer connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
        return this;
    }

    public JerseyDockerCmdExecFactory withClientResponseFilters(ClientResponseFilter ... clientResponseFilter) {
        this.clientResponseFilters = clientResponseFilter;
        return this;
    }

    public JerseyDockerCmdExecFactory withClientRequestFilters(ClientRequestFilter ... clientRequestFilters) {
        this.clientRequestFilters = clientRequestFilters;
        return this;
    }

    public JerseyDockerCmdExecFactory withRequestEntityProcessing(RequestEntityProcessing requestEntityProcessing) {
        this.requestEntityProcessing = requestEntityProcessing;
        return this;
    }

    public void releaseConnection(long idleSeconds) {
        this.connManager.closeExpiredConnections();
        this.connManager.closeIdleConnections(idleSeconds, TimeUnit.SECONDS);
    }
}

