/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.exception.UnauthorizedException;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.InvocationBuilder;
import com.github.dockerjava.core.MediaType;
import com.github.dockerjava.core.async.FrameStreamProcessor;
import com.github.dockerjava.core.async.JsonStreamProcessor;
import com.github.dockerjava.core.async.ResponseStreamProcessor;
import com.github.dockerjava.jaxrs.async.GETCallbackNotifier;
import com.github.dockerjava.jaxrs.async.POSTCallbackNotifier;
import com.github.dockerjava.jaxrs.util.WrappedResponseInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;

class JerseyInvocationBuilder
implements InvocationBuilder {
    private final ObjectMapper objectMapper;
    private final Invocation.Builder resource;

    JerseyInvocationBuilder(ObjectMapper objectMapper, Invocation.Builder resource) {
        this.objectMapper = objectMapper;
        this.resource = resource;
    }

    public InvocationBuilder accept(MediaType mediaType) {
        this.resource.accept(new String[]{mediaType.getMediaType()});
        return this;
    }

    public InvocationBuilder header(String name, String value) {
        this.resource.header(name, (Object)value);
        return this;
    }

    public void delete() {
        this.resource.delete().close();
    }

    public void get(ResultCallback<Frame> resultCallback) {
        try {
            GETCallbackNotifier<Frame> getCallbackNotifier = new GETCallbackNotifier<Frame>((ResponseStreamProcessor<Frame>)new FrameStreamProcessor(), resultCallback, this.resource);
            getCallbackNotifier.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T get(TypeReference<T> typeReference) {
        try (Response response = this.resource.get();){
            Object object = this.objectMapper.readValue((InputStream)response.readEntity(InputStream.class), typeReference);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void get(TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        try {
            GETCallbackNotifier<T> getCallbackNotifier = new GETCallbackNotifier<T>(new JsonStreamProcessor(this.objectMapper, typeReference), resultCallback, this.resource);
            getCallbackNotifier.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream post(Object entity) {
        return new WrappedResponseInputStream(this.resource.post(JerseyInvocationBuilder.toEntity(entity, "application/json")));
    }

    public void post(Object entity, InputStream stdin, ResultCallback<Frame> resultCallback) {
        if (stdin != null) {
            throw new UnsupportedOperationException("Passing stdin to the container is currently not supported.");
        }
        POSTCallbackNotifier<Frame> postCallbackNotifier = new POSTCallbackNotifier<Frame>((ResponseStreamProcessor<Frame>)new FrameStreamProcessor(), resultCallback, this.resource, JerseyInvocationBuilder.toEntity(entity, "application/json"));
        postCallbackNotifier.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T post(Object entity, TypeReference<T> typeReference) {
        Response response = this.resource.post(JerseyInvocationBuilder.toEntity(entity, "application/json"));
        if (response.getStatus() == 401) {
            throw new UnauthorizedException("Unauthorized");
        }
        try (InputStream inputStream = (InputStream)response.readEntity(InputStream.class);){
            Object object = this.objectMapper.readValue(inputStream, typeReference);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void post(Object entity, TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        try {
            POSTCallbackNotifier<T> postCallbackNotifier = new POSTCallbackNotifier<T>(new JsonStreamProcessor(this.objectMapper, typeReference), resultCallback, this.resource, JerseyInvocationBuilder.toEntity(entity, "application/json"));
            postCallbackNotifier.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T post(TypeReference<T> typeReference, InputStream body) {
        try (Response response = this.resource.post(JerseyInvocationBuilder.toEntity(body, "application/octet-stream"));){
            InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
            Object object = this.objectMapper.readValue(inputStream, typeReference);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void post(TypeReference<T> typeReference, ResultCallback<T> resultCallback, InputStream body) {
        try {
            POSTCallbackNotifier<T> postCallbackNotifier = new POSTCallbackNotifier<T>(new JsonStreamProcessor(this.objectMapper, typeReference), resultCallback, this.resource, JerseyInvocationBuilder.toEntity(body, "application/tar"));
            postCallbackNotifier.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void postStream(InputStream body) {
        this.resource.post(JerseyInvocationBuilder.toEntity(body, "application/octet-stream")).close();
    }

    public InputStream get() {
        return new WrappedResponseInputStream(this.resource.get());
    }

    public void put(InputStream body, MediaType mediaType) {
        this.resource.put(JerseyInvocationBuilder.toEntity(body, mediaType.getMediaType())).close();
    }

    private static <T> Entity<T> toEntity(T entity, String mediaType) {
        if (entity == null) {
            return null;
        }
        return Entity.entity(entity, (String)mediaType);
    }
}

