/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.SELContext;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.testng.annotations.Test;

public class BindTest {
    @Test
    public void parseUsingDefaultAccessMode() {
        Bind bind = Bind.parse((String)"/host:/container");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.DEFAULT));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
    }

    @Test
    public void parseReadWrite() {
        Bind bind = Bind.parse((String)"/host:/container:rw");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
    }

    @Test
    public void parseReadOnly() {
        Bind bind = Bind.parse((String)"/host:/container:ro");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.ro));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
    }

    @Test
    public void parseSELOnly() {
        Bind bind = Bind.parse((String)"/host:/container:Z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.DEFAULT));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.single));
        bind = Bind.parse((String)"/host:/container:z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.DEFAULT));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.shared));
    }

    @Test
    public void parseReadWriteSEL() {
        Bind bind = Bind.parse((String)"/host:/container:rw,Z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.single));
    }

    @Test
    public void parseReadOnlySEL() {
        Bind bind = Bind.parse((String)"/host:/container:ro,z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.ro));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.shared));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing Bind.*")
    public void parseInvalidAccessMode() {
        Bind.parse((String)"/host:/container:xx");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing Bind 'nonsense'")
    public void parseInvalidInput() {
        Bind.parse((String)"nonsense");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing Bind 'null'")
    public void parseNull() {
        Bind.parse(null);
    }

    @Test
    public void toStringReadOnly() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:ro").toString(), (Matcher)Is.is((Object)"/host:/container:ro"));
    }

    @Test
    public void toStringReadWrite() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:rw").toString(), (Matcher)Is.is((Object)"/host:/container:rw"));
    }

    @Test
    public void toStringDefaultAccessMode() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container").toString(), (Matcher)Is.is((Object)"/host:/container:rw"));
    }

    @Test
    public void toStringReadOnlySEL() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:ro,Z").toString(), (Matcher)Is.is((Object)"/host:/container:ro,Z"));
    }

    @Test
    public void toStringReadWriteSEL() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:rw,z").toString(), (Matcher)Is.is((Object)"/host:/container:rw,z"));
    }

    @Test
    public void toStringDefaultSEL() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:Z").toString(), (Matcher)Is.is((Object)"/host:/container:rw,Z"));
    }
}

