/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.model.Event;
import com.github.dockerjava.api.model.EventActor;
import com.github.dockerjava.api.model.EventType;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.test.serdes.JSONSamples;
import java.io.IOException;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class EventsTest {
    @Test
    public void serderDocs1() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JavaType type = mapper.getTypeFactory().uncheckedSimpleType(Event.class);
        Event event = (Event)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_24, "/events/docs1.json", type);
        MatcherAssert.assertThat((Object)event, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)event.getType(), (Matcher)CoreMatchers.is((Object)EventType.CONTAINER));
        MatcherAssert.assertThat((Object)event.getAction(), (Matcher)CoreMatchers.is((Object)"create"));
        MatcherAssert.assertThat((Object)event.getId(), (Matcher)CoreMatchers.is((Object)"ede54ee1afda366ab42f824e8a5ffd195155d853ceaec74a927f249ea270c743"));
        MatcherAssert.assertThat((Object)event.getFrom(), (Matcher)CoreMatchers.is((Object)"alpine"));
        MatcherAssert.assertThat((Object)event.getTime(), (Matcher)CoreMatchers.is((Object)1461943101L));
        MatcherAssert.assertThat((Object)event.getNode(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)event.getTimeNano(), (Matcher)CoreMatchers.is((Object)1461943101381709551L));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("com.example.some-label", "some-label-value");
        attributes.put("image", "alpine");
        attributes.put("name", "my-container");
        EventActor actor = new EventActor().withId("ede54ee1afda366ab42f824e8a5ffd195155d853ceaec74a927f249ea270c743").withAttributes(attributes);
        Event event1 = new Event().withType(EventType.CONTAINER).withStatus("create").withId("ede54ee1afda366ab42f824e8a5ffd195155d853ceaec74a927f249ea270c743").withFrom("alpine").withTime(Long.valueOf(1461943101L)).withTimenano(Long.valueOf(1461943101381709551L)).withAction("create").withEventActor(actor);
        MatcherAssert.assertThat((Object)event1, (Matcher)CoreMatchers.equalTo((Object)event));
    }
}

