/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.Link;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LinkTest {
    @Test
    public void parse() {
        Link link = Link.parse((String)"name:alias");
        Assert.assertEquals((String)link.getName(), (String)"name");
        Assert.assertEquals((String)link.getAlias(), (String)"alias");
    }

    @Test
    public void parseWithContainerNames() {
        Link link = Link.parse((String)"/name:/conatiner/alias");
        Assert.assertEquals((String)link.getName(), (String)"name");
        Assert.assertEquals((String)link.getAlias(), (String)"alias");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing Link 'nonsense'")
    public void parseInvalidInput() {
        Link.parse((String)"nonsense");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing Link 'null'")
    public void parseNull() {
        Link.parse(null);
    }

    @Test
    public void stringify() {
        Assert.assertEquals((String)Link.parse((String)"name:alias").toString(), (String)"name:alias");
    }
}

