/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.RestartPolicy;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RestartPolicy_ParsingTest {
    @Test
    public void noRestart() throws Exception {
        Assert.assertEquals((Object)RestartPolicy.parse((String)"no"), (Object)RestartPolicy.noRestart());
    }

    @Test
    public void alwaysRestart() throws Exception {
        Assert.assertEquals((Object)RestartPolicy.parse((String)"always"), (Object)RestartPolicy.alwaysRestart());
    }

    @Test
    public void onFailureRestart() throws Exception {
        Assert.assertEquals((Object)RestartPolicy.parse((String)"on-failure"), (Object)RestartPolicy.onFailureRestart((int)0));
    }

    @Test
    public void onFailureRestartWithCount() throws Exception {
        Assert.assertEquals((Object)RestartPolicy.parse((String)"on-failure:2"), (Object)RestartPolicy.onFailureRestart((int)2));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing RestartPolicy 'nonsense'")
    public void illegalSyntax() throws Exception {
        RestartPolicy.parse((String)"nonsense");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing RestartPolicy 'on-failure:X'")
    public void illegalRetryCount() throws Exception {
        RestartPolicy.parse((String)"on-failure:X");
    }
}

