/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.LocalDirectorySSLConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.SSLConfig;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.SerializationUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultDockerClientConfigTest {
    public static final DefaultDockerClientConfig EXAMPLE_CONFIG = DefaultDockerClientConfigTest.newExampleConfig();

    private static DefaultDockerClientConfig newExampleConfig() {
        String dockerCertPath = DefaultDockerClientConfigTest.dockerCertPath();
        return new DefaultDockerClientConfig(URI.create("tcp://foo"), "dockerConfig", "apiVersion", "registryUrl", "registryUsername", "registryPassword", "registryEmail", (SSLConfig)new LocalDirectorySSLConfig(dockerCertPath));
    }

    private static String homeDir() {
        return "target/test-classes/someHomeDir";
    }

    private static String dockerCertPath() {
        return DefaultDockerClientConfigTest.homeDir() + "/.docker";
    }

    @Test
    public void equals() throws Exception {
        Assert.assertEquals((Object)EXAMPLE_CONFIG, (Object)DefaultDockerClientConfigTest.newExampleConfig());
    }

    @Test
    public void environmentDockerHost() throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("DOCKER_HOST", "tcp://baz:8768");
        env.remove("DOCKER_CERT_PATH");
        Properties systemProperties = new Properties();
        systemProperties.setProperty("user.name", "someUserName");
        systemProperties.setProperty("user.home", DefaultDockerClientConfigTest.homeDir());
        DefaultDockerClientConfig config = this.buildConfig(env, systemProperties);
        Assert.assertEquals((Object)config.getDockerHost(), (Object)URI.create("tcp://baz:8768"));
    }

    @Test
    public void environment() throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("DOCKER_HOST", "tcp://foo");
        env.put("api.version", "apiVersion");
        env.put("registry.username", "registryUsername");
        env.put("registry.password", "registryPassword");
        env.put("registry.email", "registryEmail");
        env.put("registry.url", "registryUrl");
        env.put("DOCKER_CONFIG", "dockerConfig");
        env.put("DOCKER_CERT_PATH", DefaultDockerClientConfigTest.dockerCertPath());
        env.put("DOCKER_TLS_VERIFY", "1");
        DefaultDockerClientConfig config = this.buildConfig(env, new Properties());
        Assert.assertEquals((Object)config, (Object)EXAMPLE_CONFIG);
    }

    private DefaultDockerClientConfig buildConfig(Map<String, String> env, Properties systemProperties) {
        return DefaultDockerClientConfig.createDefaultConfigBuilder(env, (Properties)systemProperties).build();
    }

    @Test
    public void defaults() throws Exception {
        Properties systemProperties = new Properties();
        systemProperties.setProperty("user.name", "someUserName");
        systemProperties.setProperty("user.home", DefaultDockerClientConfigTest.homeDir());
        DefaultDockerClientConfig config = this.buildConfig(Collections.emptyMap(), systemProperties);
        Assert.assertEquals((Object)config.getDockerHost(), (Object)URI.create("unix:///var/run/docker.sock"));
        Assert.assertEquals((String)config.getRegistryUsername(), (String)"someUserName");
        Assert.assertEquals((String)config.getRegistryUrl(), (String)"https://index.docker.io/v1/");
        Assert.assertEquals((Object)config.getApiVersion(), (Object)RemoteApiVersion.unknown());
        Assert.assertEquals((String)config.getDockerConfig(), (String)(DefaultDockerClientConfigTest.homeDir() + "/.docker"));
        Assert.assertNull((Object)config.getSSLConfig());
    }

    @Test
    public void systemProperties() throws Exception {
        Properties systemProperties = new Properties();
        systemProperties.put("DOCKER_HOST", "tcp://foo");
        systemProperties.put("api.version", "apiVersion");
        systemProperties.put("registry.username", "registryUsername");
        systemProperties.put("registry.password", "registryPassword");
        systemProperties.put("registry.email", "registryEmail");
        systemProperties.put("registry.url", "registryUrl");
        systemProperties.put("DOCKER_CONFIG", "dockerConfig");
        systemProperties.put("DOCKER_CERT_PATH", DefaultDockerClientConfigTest.dockerCertPath());
        systemProperties.put("DOCKER_TLS_VERIFY", "1");
        DefaultDockerClientConfig config = this.buildConfig(Collections.emptyMap(), systemProperties);
        Assert.assertEquals((Object)config, (Object)EXAMPLE_CONFIG);
    }

    @Test
    public void serializableTest() {
        byte[] serialized = SerializationUtils.serialize((Serializable)EXAMPLE_CONFIG);
        DefaultDockerClientConfig deserialized = (DefaultDockerClientConfig)SerializationUtils.deserialize((byte[])serialized);
        MatcherAssert.assertThat((String)"Deserialized object mush match source object", (Object)deserialized, (Matcher)Matchers.equalTo((Object)EXAMPLE_CONFIG));
    }

    @Test
    public void testSslContextEmpty() throws Exception {
        new DefaultDockerClientConfig(URI.create("tcp://foo"), "dockerConfig", "apiVersion", "registryUrl", "registryUsername", "registryPassword", "registryEmail", null);
    }

    @Test
    public void testTlsVerifyAndCertPath() throws Exception {
        new DefaultDockerClientConfig(URI.create("tcp://foo"), "dockerConfig", "apiVersion", "registryUrl", "registryUsername", "registryPassword", "registryEmail", (SSLConfig)new LocalDirectorySSLConfig(DefaultDockerClientConfigTest.dockerCertPath()));
    }

    @Test(expectedExceptions={DockerClientException.class})
    public void testWrongHostScheme() throws Exception {
        new DefaultDockerClientConfig(URI.create("http://foo"), "dockerConfig", "apiVersion", "registryUrl", "registryUsername", "registryPassword", "registryEmail", null);
    }

    @Test
    public void testTcpHostScheme() throws Exception {
        new DefaultDockerClientConfig(URI.create("tcp://foo"), "dockerConfig", "apiVersion", "registryUrl", "registryUsername", "registryPassword", "registryEmail", null);
    }

    @Test
    public void testUnixHostScheme() throws Exception {
        new DefaultDockerClientConfig(URI.create("unix://foo"), "dockerConfig", "apiVersion", "registryUrl", "registryUsername", "registryPassword", "registryEmail", null);
    }

    @Test
    public void withDockerTlsVerify() throws Exception {
        DefaultDockerClientConfig.Builder builder = new DefaultDockerClientConfig.Builder();
        Field field = builder.getClass().getDeclaredField("dockerTlsVerify");
        field.setAccessible(true);
        builder.withDockerTlsVerify("");
        MatcherAssert.assertThat((Object)((Boolean)field.get(builder)), (Matcher)Is.is((Object)false));
        builder.withDockerTlsVerify("false");
        MatcherAssert.assertThat((Object)((Boolean)field.get(builder)), (Matcher)Is.is((Object)false));
        builder.withDockerTlsVerify("FALSE");
        MatcherAssert.assertThat((Object)((Boolean)field.get(builder)), (Matcher)Is.is((Object)false));
        builder.withDockerTlsVerify("true");
        MatcherAssert.assertThat((Object)((Boolean)field.get(builder)), (Matcher)Is.is((Object)true));
        builder.withDockerTlsVerify("TRUE");
        MatcherAssert.assertThat((Object)((Boolean)field.get(builder)), (Matcher)Is.is((Object)true));
        builder.withDockerTlsVerify("0");
        MatcherAssert.assertThat((Object)((Boolean)field.get(builder)), (Matcher)Is.is((Object)false));
        builder.withDockerTlsVerify("1");
        MatcherAssert.assertThat((Object)((Boolean)field.get(builder)), (Matcher)Is.is((Object)true));
    }
}

