/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.core.command.BuildImageResultCallback;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerfileFixture
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerfileFixture.class);
    private final DockerClient dockerClient;
    private String directory;
    private String repository;
    private String containerId;

    public DockerfileFixture(DockerClient dockerClient, String directory) {
        this.dockerClient = dockerClient;
        this.directory = directory;
    }

    public void open() throws Exception {
        LOGGER.info("building {}", (Object)this.directory);
        ((BuildImageResultCallback)this.dockerClient.buildImageCmd(new File("src/test/resources", this.directory)).withNoCache(Boolean.valueOf(true)).exec((ResultCallback)new BuildImageResultCallback())).awaitImageId();
        Image lastCreatedImage = (Image)((List)this.dockerClient.listImagesCmd().exec()).get(0);
        this.repository = lastCreatedImage.getRepoTags()[0];
        LOGGER.info("created {} {}", (Object)lastCreatedImage.getId(), (Object)this.repository);
        this.containerId = this.dockerClient.createContainerCmd(lastCreatedImage.getId()).exec().getId();
        LOGGER.info("starting {}", (Object)this.containerId);
        this.dockerClient.startContainerCmd(this.containerId).exec();
    }

    @Override
    public void close() throws Exception {
        if (this.containerId != null) {
            LOGGER.info("removing container {}", (Object)this.containerId);
            try {
                this.dockerClient.removeContainerCmd(this.containerId).withForce(Boolean.valueOf(true)).exec();
            }
            catch (InternalServerErrorException | NotFoundException ignored) {
                LOGGER.info("ignoring {}", (Object)ignored.getMessage());
            }
            this.containerId = null;
        }
        if (this.repository != null) {
            LOGGER.info("removing repository {}", (Object)this.repository);
            try {
                this.dockerClient.removeImageCmd(this.repository).withForce(Boolean.valueOf(true)).exec();
            }
            catch (InternalServerErrorException | NotFoundException e) {
                LOGGER.info("ignoring {}", (Object)e.getMessage());
            }
            this.repository = null;
        }
    }

    public String getContainerId() {
        return this.containerId;
    }
}

