/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.client.AbstractDockerClientTest;
import com.github.dockerjava.core.command.PullImageCmdImpl;
import com.github.dockerjava.core.command.PullImageResultCallback;
import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class PullImageCmdImplTest
extends AbstractDockerClientTest {
    private static final PullImageCmd.Exec NOP_EXEC = new PullImageCmd.Exec(){

        public Void exec(PullImageCmd command, ResultCallback<PullResponseItem> resultCallback) {
            return null;
        }
    };

    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void nullAuthConfig() throws Exception {
        try (PullImageCmdImpl pullImageCmd = new PullImageCmdImpl(NOP_EXEC, null, "");){
            pullImageCmd.withAuthConfig(null);
            PullImageCmdImplTest.fail();
        }
    }

    @Test
    public void testPullImage() throws Exception {
        Info info = (Info)this.dockerClient.infoCmd().exec();
        LOG.info("Client info: {}", (Object)info.toString());
        int imgCount = info.getImages();
        LOG.info("imgCount1: {}", (Object)imgCount);
        String testImage = "hackmann/empty";
        LOG.info("Removing image: {}", (Object)testImage);
        try {
            this.dockerClient.removeImageCmd(testImage).withForce(Boolean.valueOf(true)).exec();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        info = (Info)this.dockerClient.infoCmd().exec();
        LOG.info("Client info: {}", (Object)info.toString());
        imgCount = info.getImages();
        LOG.info("imgCount2: {}", (Object)imgCount);
        LOG.info("Pulling image: {}", (Object)testImage);
        ((PullImageResultCallback)this.dockerClient.pullImageCmd(testImage).exec((ResultCallback)new PullImageResultCallback())).awaitSuccess();
        info = (Info)this.dockerClient.infoCmd().exec();
        LOG.info("Client info after pull, {}", (Object)info.toString());
        MatcherAssert.assertThat((Object)imgCount, (Matcher)Matchers.lessThanOrEqualTo((Comparable)info.getImages()));
        InspectImageResponse inspectImageResponse = this.dockerClient.inspectImageCmd(testImage).exec();
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testPullNonExistingImage() throws Exception {
        ((PullImageResultCallback)this.dockerClient.pullImageCmd("xvxcv/foo").exec((ResultCallback)new PullImageResultCallback())).awaitCompletion();
    }
}

