/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.client.AbstractDockerClientTest;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.github.dockerjava.core.command.PushImageResultCallback;
import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration-auth", "integration"})
public class PushImageCmdImplTest
extends AbstractDockerClientTest {
    public static final Logger LOG = LoggerFactory.getLogger(PushImageCmdImplTest.class);
    String username;

    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
        this.username = this.dockerClient.authConfig().getUsername();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void pushLatest() throws Exception {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        LOG.info("Committing container: {}", (Object)container.toString());
        String imageId = this.dockerClient.commitCmd(container.getId()).withRepository(this.username + "/busybox").exec();
        ((PushImageResultCallback)this.dockerClient.pushImageCmd(this.username + "/busybox").exec((ResultCallback)new PushImageResultCallback())).awaitSuccess();
        LOG.info("Removing image: {}", (Object)imageId);
        this.dockerClient.removeImageCmd(imageId).exec();
        ((PullImageResultCallback)this.dockerClient.pullImageCmd(this.username + "/busybox").exec((ResultCallback)new PullImageResultCallback())).awaitSuccess();
    }

    @Test(expectedExceptions={DockerClientException.class})
    public void pushNonExistentImage() throws Exception {
        ((PushImageResultCallback)this.dockerClient.pushImageCmd(this.username + "/xxx").exec((ResultCallback)new PushImageResultCallback())).awaitSuccess();
    }
}

