/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import com.github.dockerjava.core.command.AttachContainerResultCallback;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class AttachContainerCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void attachContainerWithoutTTY() throws Exception {
        String snippet = "hello world";
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"echo", snippet}).withTty(Boolean.valueOf(false)).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        AttachContainerTestCallback callback = new AttachContainerTestCallback(){

            @Override
            public void onNext(Frame frame) {
                Assert.assertEquals((Object)frame.getStreamType(), (Object)StreamType.STDOUT);
                super.onNext(frame);
            }
        };
        ((AttachContainerTestCallback)this.dockerClient.attachContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withLogs(Boolean.valueOf(true)).exec((ResultCallback)callback)).awaitCompletion(10L, TimeUnit.SECONDS);
        callback.close();
        MatcherAssert.assertThat((Object)callback.toString(), (Matcher)Matchers.containsString((String)snippet));
    }

    @Test
    public void attachContainerWithStdin() throws Exception {
        String snippet = "hello world";
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"/bin/sh", "-c", "sleep 1 && read line && echo $line"}).withTty(Boolean.valueOf(false)).withStdinOpen(Boolean.valueOf(true)).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        AttachContainerCmdExecTest.assertTrue((boolean)inspectContainerResponse.getState().getRunning());
        AttachContainerTestCallback callback = new AttachContainerTestCallback(){

            @Override
            public void onNext(Frame frame) {
                Assert.assertEquals((Object)frame.getStreamType(), (Object)StreamType.STDOUT);
                super.onNext(frame);
            }
        };
        ByteArrayInputStream stdin = new ByteArrayInputStream((snippet + "\n").getBytes());
        ((AttachContainerTestCallback)this.dockerClient.attachContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withStdIn((InputStream)stdin).exec((ResultCallback)callback)).awaitCompletion(15L, TimeUnit.SECONDS);
        callback.close();
        MatcherAssert.assertThat((Object)callback.toString(), (Matcher)Matchers.containsString((String)snippet));
    }

    @Test
    public void attachContainerWithTTY() throws Exception {
        File baseDir = new File(Thread.currentThread().getContextClassLoader().getResource("attachContainerTestDockerfile").getFile());
        String imageId = this.buildImage(baseDir);
        CreateContainerResponse container = this.dockerClient.createContainerCmd(imageId).withTty(Boolean.valueOf(true)).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        AttachContainerTestCallback callback = new AttachContainerTestCallback(){

            @Override
            public void onNext(Frame frame) {
                Assert.assertEquals((Object)frame.getStreamType(), (Object)StreamType.RAW);
                super.onNext(frame);
            }
        };
        ((AttachContainerTestCallback)this.dockerClient.attachContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).exec((ResultCallback)callback)).awaitCompletion(10L, TimeUnit.SECONDS);
        callback.close();
        MatcherAssert.assertThat((Object)callback.toString(), (Matcher)Matchers.containsString((String)"stdout\r\nstderr"));
    }

    public static class AttachContainerTestCallback
    extends AttachContainerResultCallback {
        private StringBuffer log = new StringBuffer();

        public void onNext(Frame item) {
            this.log.append(new String(item.getPayload()));
            super.onNext(item);
        }

        public String toString() {
            return this.log.toString();
        }
    }
}

