/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import java.lang.reflect.Method;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class CreateNetworkCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void createNetwork() throws DockerException {
        String networkName = "testNetwork";
        CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.dockerClient.createNetworkCmd().withName(networkName).exec();
        CreateNetworkCmdExecTest.assertNotNull((Object)createNetworkResponse.getId());
        Network network = this.dockerClient.inspectNetworkCmd().withNetworkId(createNetworkResponse.getId()).exec();
        CreateNetworkCmdExecTest.assertEquals((String)network.getName(), (String)networkName);
        CreateNetworkCmdExecTest.assertEquals((String)network.getDriver(), (String)"bridge");
    }

    @Test
    public void createNetworkWithIpamConfig() throws DockerException {
        String networkName = "testNetwork";
        Network.Ipam ipam = new Network.Ipam().withConfig(new Network.Ipam.Config[]{new Network.Ipam.Config().withSubnet("10.67.79.0/24")});
        CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.dockerClient.createNetworkCmd().withName(networkName).withIpam(ipam).exec();
        CreateNetworkCmdExecTest.assertNotNull((Object)createNetworkResponse.getId());
        Network network = this.dockerClient.inspectNetworkCmd().withNetworkId(createNetworkResponse.getId()).exec();
        CreateNetworkCmdExecTest.assertEquals((String)network.getName(), (String)networkName);
        CreateNetworkCmdExecTest.assertEquals((String)network.getDriver(), (String)"bridge");
        CreateNetworkCmdExecTest.assertEquals((String)"10.67.79.0/24", (String)((Network.Ipam.Config)network.getIpam().getConfig().iterator().next()).getSubnet());
    }
}

