/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class ExecCreateCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test(groups={"ignoreInCircleCi"})
    public void execCreateTest() {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"top"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(container.getId()).withCmd(new String[]{"touch", "file.log"}).exec();
        MatcherAssert.assertThat((Object)execCreateCmdResponse.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
    }
}

